<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calendar</title>
    <link rel="stylesheet" href="../_includes/localCss/bootstrap.min.css">
    <link rel="stylesheet" href="css/calendar.css">
    <link rel="stylesheet" href="css/main.css">
    <style>
/* Base styling for your numbered list */
.test-ol {

  color:               #154463ff;   /* text + marker color */
}

.test-ol ul {
  margin: 0 !important;            /* bottom margin creates the gap */
  padding: 0 !important;                     /* ensure no extra padding */
}
/* Add vertical spacing between each <li> */
.test-ol li {
        /* bottom margin creates the gap */
  padding-left: 0 !important;                     /* ensure no extra padding */
}

/* Reinforce marker color */
.test-ol li::marker {
  color: #3498db;
}

/* Optional: remove gap after the last item */
.test-ol li:first-child {
  margin-bottom: 20px;
}

/* Optional: remove gap after the last item */
.test-ol li:last-child {
  margin-bottom: 0;
}

.hash-bullets {
  list-style: none;
  margin-block-start: 0;
  margin-block-end:   0;
  padding-inline-start: 0;
}

.hash-bullets li {
  margin-block-end: 0.5em;
  /* remove this if you’d rather the list sit flush */
  padding-inline-start: 0;
  position: relative;      /* not needed once ::before is inline-block */
}

.hash-bullets li::before {
  content: "#";
  display: inline-block;
  padding-right: 2px;      /* ← your requested gap */
  color: currentColor;
  font-weight: bold;
  line-height: 1;
}



    </style> 
    </head>   
<body>
  <div class="calendar-container">
    <div class="controls">
      <button onclick="changeMonth(-1)">&#9665;</button>

      <div class="month-controls">
        <div class="month-label" id="monthYear">
          September 23, 2025
        </div>
        <button id="refreshButton" onclick="loadCalendarData()" 
                title="Refresh Calendar"><span class="text-primary"><strong>&#x21bb;</strong></span><span class="text-primary smallertext"> Refresh</span>
        </button> 
      </div>

      <button onclick="changeMonth(1)">&#9655;</button>
    </div>

    <div class="week">
      <div class="weekDiv">SUN</div>
      <div class="weekDiv">MON</div>
      <div class="weekDiv">TUE</div>
      <div class="weekDiv">WED</div>
      <div class="weekDiv">THU</div>
      <div class="weekDiv">FRI</div>
      <div class="weekDiv">SAT</div>
    </div>

    <div class="days"></div>
  </div>

  <!-- Modal -->

    <div class="modal-overlay" id="modalOverlay"></div>

<div class="modal" id="modal">
  <div class="modal-header">
    <h5 id="modalHeader"></h5>
  </div>

  <div class="modal-inner">
    <div id="modalContent"></div>
  </div>

  <div class="modal-footer">
    <button class="close-btn" onclick="closeModal()">Close</button>
  </div>
</div>
<!-- Modal Popup -->
<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="js/isAlive.js"></script> 
<script src="js/calendar.js"></script>
</body>
</html>

