<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once "loginCheck.php";
require_once "_dbconfig.php";
function simpleSelect($sql) {
	try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME. ";charset=UTF8";
        //Step 2 - establish database connection
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        //Step 3 - execute an SQL statement
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        //Step 4 - process the query results
        //return the array of results
        return $stmt->fetchAll();
    } catch (Exception $ex) {
        echo "DB Exception: " . $ex->getMessage();
        return null;
    } finally {
        //Step 5 - close your database connection
        $pdo = null;
    }
}
function preparedSelect($sql, $params) {
	try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME. ";charset=UTF8";
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    } catch (Exception $ex) {
        echo "DB Exception: " . $ex->getMessage();
        return null;
    } finally {
        $pdo = null;
    }
}
/*
function preparedSelect($sql, $params) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare($sql);
$stmt->bindParam(1, $params,PDO::PARAM_INT);
        // Ensure that $params is an array and has the correct number of elements
        if(is_array($params) && count($params) === substr_count($sql, '?')) {
            $stmt->execute($params);
            return $stmt->fetchAll();
        } else {
			 //throw new Exception(" Parameter count does not match query placeholders.");
           throw new Exception(count($params)." and - ".$sql." - Parameter count does not match query placeholders. - ".substr_count($sql, '?')." *** ");
        }
    } catch (Exception $ex) {
        echo "DB Exception: " . $ex->getMessage();
        return null;
    } finally {
        $pdo = null;
    }
}
*/

/*
function preparedSelect($sql, $params,$callerFunction) {
	try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		//$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
		
    } catch (Exception $ex) {
       // echo "DB Exception: ".$callerFunction. " (*)|(*)" . $ex->getMessage();
        return null;
    } finally {
	//throw new Exception(count($params)." and - ".$sql." - Parameter count match query placeholders. - ".substr_count($sql, '?')." *** ");
	//echo $callerFunction."<br> sql - ".$sql."<br> - Param count = (".count($params).") match placeholders = ".substr_count($sql, '?')." <br>--------------<br>";
        $pdo = null;
    }
}
*/

function getLastWorkOrderNumber($type) {
	$sql = "SELECT MAX(wo_number) AS last_number FROM WorkOrder WHERE type = ?";
	$params = array($type);
	return preparedSelect($sql, $params);
}
function getLastWorkOrderNumberBasic() {
	$sql = "SELECT MAX(wo_number) AS last_number FROM WorkOrder";
	//$params = array($type);
	//return preparedSelect($sql, $params);
	return simpleSelect($sql);
}

function getUser($username, $password) {
	$sql = "SELECT * FROM Users WHERE username = ? AND password = ? COLLATE latin1_bin";
	$params = array($username, $password);
	return preparedSelect($sql, $params);
}

/*
function getCallLog($type, $status = "all") {
	if ($status == "all") {
		$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ?";
		$params = array($type);
	} else {
		$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND wo.status = ?";
    	$params = array($type, $status);
	}
    return preparedSelect($sql, $params);
}
	*/
function getCallLog($type, $status = "all") {
    if ($status == "all") {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.type = ?";
        
        $params = array($type);
    } else {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.type = ? AND wo.status = ?";
        
        $params = array($type, $status);
    }

    return preparedSelect($sql, $params);
}





/*before groups  status.php (Cabinets)  all WorkOeder.status 
function getCallLogStatus($type) {
		$sql = "SELECT wo.*,  c.address, c.unit_suite, d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ?  ORDER BY productionSchedulingDate ASC";
    	$params = array($type);	
    return preparedSelect($sql, $params);
}
*/

function getCallLogStatusService($type) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo 
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.type = ?  
	AND wo.status NOT IN ('complete','cancelled')
    ORDER BY productionSchedulingDate ASC";

    $params = array($type); 
    return preparedSelect($sql, $params);
}
function getCallLogStatus($type) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo 
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.type = ?  
    ORDER BY productionSchedulingDate ASC";

    $params = array($type); 
    return preparedSelect($sql, $params);
}

function getStatusDuo($type1, $type2 = null) {
    $sql = "SELECT 
                wo.*,  
                c.address, 
                c.unit_suite, 
                d.company_name, 
                g.group_id, 
                g.group_title, 
                g.group_color
            FROM WorkOrder AS wo 
            INNER JOIN Customer AS c ON c.id = wo.customer_id 
            LEFT JOIN Company AS d ON d.id = c.company_id 
            LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
                AND wo.groupId IS NOT NULL 
                AND wo.groupId != ''
            WHERE wo.status NOT IN ('complete','cancelled')";

    $params = [];

    // Add type filter
    if ($type2 === null) {
        $sql .= " AND wo.type = ?";
        $params[] = $type1;
    } else {
        $sql .= " AND (wo.type = ? OR wo.type = ?)";
        $params[] = $type1;
        $params[] = $type2;
    }

    $sql .= " ORDER BY productionSchedulingDate ASC";

    return preparedSelect($sql, $params);
}







// production.php (Cabinets)  show campany_name
/*
function getCallLogProduction($type, $status) {
		$sql = "SELECT wo.*,  c.address, c.unit_suite, p.stage_1,p.stage_2,p.stage_3,p.stage_4, d.company_name FROM WorkOrder AS wo INNER JOIN ProgressTracking AS p ON p.wo_number_track  = wo.wo_number INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ? AND wo.status = ? ORDER BY productionSchedulingDate ASC";
    	$params = array($type, $status);	
    return preparedSelect($sql, $params);
}
*/
//BASIC 1 $type
function getCallLogProduction($type, $status) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        p.stage_1, 
        p.stage_2, 
        p.stage_3, 
        p.stage_4, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo 
    INNER JOIN ProgressTracking AS p ON p.wo_number_track = wo.wo_number 
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.type = ? AND wo.status = ? 
    ORDER BY productionSchedulingDate ASC";

    $params = array($type, $status);    
    return preparedSelect($sql, $params);
}

function getCallLogProductionDuo($type1, $status, $type2 = null) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        p.stage_1, 
        p.stage_2, 
        p.stage_3, 
        p.stage_4, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo 
    INNER JOIN ProgressTracking AS p ON p.wo_number_track = wo.wo_number 
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != '' 
    WHERE wo.status = ?";

    $params = [$status];

    // Add type filter
    if ($type2 === null) {
        $sql .= " AND wo.type = ?";
        $params[] = $type1;
    } else {
        $sql .= " AND (wo.type = ? OR wo.type = ?)";
        $params[] = $type1;
        $params[] = $type2;
    }

    $sql .= " ORDER BY productionSchedulingDate ASC";

    return preparedSelect($sql, $params);
}






// shipping.php (Cabinets)  show campany_name
function getCallLogShipping($type, $status) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        c.vicinity, 
        c.city, 
        c.province, 
        c.postal, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo  
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.type = ? AND wo.status = ? 
    ORDER BY service_date ASC";

    $params = array($type, $status);    
    return preparedSelect($sql, $params);
}

function getCallLogShippingDuo($type1, $status, $type2 = null) {
    $sql = "SELECT 
                wo.*,  
                c.address, 
                c.unit_suite, 
                c.vicinity, 
                c.city, 
                c.province, 
                c.postal, 
                d.company_name, 
                g.group_id, 
                g.group_title, 
                g.group_color
            FROM WorkOrder AS wo  
            INNER JOIN Customer AS c ON c.id = wo.customer_id 
            LEFT JOIN Company AS d ON d.id = c.company_id 
            LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
                AND wo.groupId IS NOT NULL 
                AND wo.groupId != ''
            WHERE (wo.type = ?";

    // If a second type is provided, allow either type1 or type2
    if ($type2 !== null) {
        $sql .= " OR wo.type = ?";
    }

    $sql .= ") AND wo.status = ? 
              ORDER BY service_date ASC";

    // Build params array depending on whether type2 is set
    $params = ($type2 !== null) 
        ? array($type1, $type2, $status) 
        : array($type1, $status);

    return preparedSelect($sql, $params);
}


// delivery.php (Cabinets)  show campany_name
function getCallLogDeliveryDuo($type1, $status, $type2 = null) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        c.vicinity, 
        c.city, 
        c.province, 
        c.postal, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo  
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
   WHERE (wo.type = ?";
      // If a second type is provided, allow either type1 or type2
    if ($type2 !== null) {
        $sql .= " OR wo.type = ?";
    }

    $sql .= ") AND wo.status = ? 
              ORDER BY service_date ASC";

    // Build params array depending on whether type2 is set
    $params = ($type2 !== null) 
        ? array($type1, $type2, $status) 
        : array($type1, $status);

    return preparedSelect($sql, $params);
}

// pickup.php (Cabinets)  show campany_name, contact
function getCallLogPickupDuo($type1, $status, $type2 = null) {
    $sql = "SELECT 
        wo.*,  
        c.address, 
        c.unit_suite, 
        c.vicinity, 
        c.city, 
        c.province, 
        c.postal, 
        c.contact_name, 
        c.contact_phone, 
        c.contact_cell, 
        d.company_name, 
        g.group_id, 
        g.group_title, 
        g.group_color
    FROM WorkOrder AS wo  
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
   WHERE (wo.type = ?";
      // If a second type is provided, allow either type1 or type2
    if ($type2 !== null) {
        $sql .= " OR wo.type = ?";
    }

    $sql .= ") AND wo.status = ? 
              ORDER BY service_date ASC";

    // Build params array depending on whether type2 is set
    $params = ($type2 !== null) 
        ? array($type1, $type2, $status) 
        : array($type1, $status);

    return preparedSelect($sql, $params);
}


/*
function getJobsLog($type, $status) {

		$sql = "SELECT wo.*, c.address, c.unit_suite, d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ? AND wo.status = ?";
    	$params = array($type, $status);

    return preparedSelect($sql, $params);
}

function getJobsLog($type, $status) {
    $sql = "SELECT 
        wo.*, 
        c.*, 
        d.*, 
        g.group_id,
        g.group_title,
        g.group_color
    FROM WorkOrder AS wo
    INNER JOIN Customer AS c ON c.id = wo.customer_id
    LEFT JOIN Company AS d ON d.id = c.company_id
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.type = ? AND wo.status = ?";

    $params = array($type, $status);

    return preparedSelect($sql, $params);
}
	*/

	/* maybe used elsewhere other than production? */
function getJobsLog($type, $status) {
    $sql = "SELECT 
        wo.*, 
        c.address, 
        c.unit_suite, 
        c.city, 
        c.postal, 
        d.company_name, 
        g.group_id,
        g.group_title,
        g.group_color
    FROM WorkOrder AS wo
    INNER JOIN Customer AS c ON c.id = wo.customer_id
    LEFT JOIN Company AS d ON d.id = c.company_id
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.type = ? AND wo.status = ?";

    $params = array($type, $status);

    return preparedSelect($sql, $params);
}

function getJobsLogDuo($type1, $status, $type2 = null) {
    $sql = "SELECT 
        wo.*, 
        c.address, 
        c.unit_suite, 
        c.city, 
        c.postal, 
        d.company_name, 
        g.group_id,
        g.group_title,
        g.group_color
    FROM WorkOrder AS wo
    INNER JOIN Customer AS c ON c.id = wo.customer_id
    LEFT JOIN Company AS d ON c.company_id = d.id
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE wo.status = ?";

    $params = [$status];

    // Add type filter
    if ($type2 === null) {
        $sql .= " AND wo.type = ?";
        $params[] = $type1;
    } else {
        $sql .= " AND (wo.type = ? OR wo.type = ?)";
        $params[] = $type1;
        $params[] = $type2;
    }

    $sql .= " ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";

    return preparedSelect($sql, $params);
}


/*
function getJobsLogReviewer($type) {
    $sql = "SELECT wo.*, c.address, c.unit_suite, d.company_name 
            FROM WorkOrder AS wo 
            INNER JOIN Customer AS c ON c.id = wo.customer_id 
            LEFT JOIN Company AS d ON d.id = c.company_id 
            WHERE wo.type = ? AND (wo.status = 'new_job' OR wo.status = 'in_review' OR wo.status = 'in_production')";
    
    $params = array($type);
    return preparedSelect($sql, $params);
}
	*/
	/* OLD
	function getJobsLogReviewer() {
    $sql = "SELECT 
        wo.*, 
        c.address, 
        c.unit_suite, 
        d.company_name, 
        g.group_id,
        g.group_title,
        g.group_color
    FROM WorkOrder AS wo 
    INNER JOIN Customer AS c ON c.id = wo.customer_id 
    LEFT JOIN Company AS d ON d.id = c.company_id 
    LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
        AND wo.groupId IS NOT NULL 
        AND wo.groupId != ''
    WHERE (wo.type = 'Doors' OR wo.type = 'Closets')
      AND (wo.status = 'new_job' OR wo.status = 'in_review' OR wo.status = 'in_production')";

  
    return preparedSelect($sql);
}
*/
function getJobsLogReviewerDuo($type1, $type2 = null) {
    $sql = "
        SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            d.company_name, 
            g.group_id,
            g.group_title,
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON c.company_id = d.id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE (wo.status IN ('new_job','in_review','in_production'))";

    $params = [];

    // Add type filter
    if ($type2 === null) {
        $sql .= " AND wo.type = ?";
        $params[] = $type1;
    } else {
        $sql .= " AND (wo.type = ? OR wo.type = ?)";
        $params[] = $type1;
        $params[] = $type2;
    }

    $sql .= " ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";

    return preparedSelect($sql, $params);
}





//function getCallLog3($type, $status = "all") {
/*
function getCallLog3($type, $status) {
	if ($status == "in_review") {
		$sql = "SELECT wo.*, c.address, c.unit_suite, d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ?";
		$params = array($type);
	} else {
		$sql = "SELECT wo.*, c.address, c.unit_suite, d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ? AND wo.status = ?";
    	$params = array($type, $status);
	}
    return preparedSelect($sql, $params);
}
	*/



	//check where used
	function getCallLog3($type, $status) {
    if ($status == "in_review") {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.type = ?";
        
        $params = array($type);
    } else {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.type = ? AND wo.status = ?";
        
        $params = array($type, $status);
    }

    return preparedSelect($sql, $params);
}
function getFinalizedDoorsClosetsDuo() {
    $sql = "
        SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE (wo.type = ? OR wo.type = ?)
          AND wo.status = 'ready_for_pricing'
        ORDER BY wo.priority ASC, wo.time_created ASC";

    // Parameters: type1 = Doors, type2 = Closets
    $params = array('Doors', 'Closets');

    return preparedSelect($sql, $params);
}


function getCallLog2($type, $status = "all") {
	if ($status == "all") {
		$sql = "SELECT 
					wo.*,
				    c.address,
				    (SELECT GROUP_CONCAT(u.name SEPARATOR ', ') FROM Users u LEFT JOIN AssignedTechs a ON a.technician_id = u.id WHERE a.work_order_id = wo.id) as 'techsX'
				FROM WorkOrder AS wo
				INNER JOIN Customer AS c 
				ON c.id = wo.customer_id 
				WHERE wo.type = ?";
		$params = array($type);
	} else {
		$sql = "SELECT 
					wo.*,
				    c.address,
				    (SELECT GROUP_CONCAT(u.name SEPARATOR ', ') FROM Users u LEFT JOIN AssignedTechs a ON a.technician_id = u.id WHERE a.work_order_id = wo.id) as 'techsXX'
				FROM WorkOrder AS wo
				INNER JOIN Customer AS c 
				ON c.id = wo.customer_id 
				WHERE wo.type = ? AND wo.status = ?";
    	$params = array($type, $status);
	}
    return preparedSelect($sql, $params);
}



function getCallLogUnscheduled($type) {
	$sql = "SELECT wo.*, c.address FROM WorkOrderUnscheduled wo INNER JOIN Customer c ON c.id = wo.customer_id WHERE wo.type = ?";
	$params = array($type);
	return preparedSelect($sql, $params);
}

// function getCallLog($type) {
//     $sql = "SELECT DISTINCT (wo.id), wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ?";
//     $params = array($type);
//     return preparedSelect($sql, $params);
// }

function getCallEntryLogByDate($type, $filter_date) {
	if (strtotime($filter_date) < time()) {
        $sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND ((wo.service_date <= ? AND wo.status = 'in_progress') OR (wo.next_service_date <= ? AND wo.status = 'ongoing')) ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    } else {
        $sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND ((wo.service_date = ? AND wo.status = 'in_progress') OR (wo.next_service_date = ? AND wo.status = 'ongoing')) ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    }
    $params = array($type, $filter_date, $filter_date);
    return preparedSelect($sql, $params);
}

/* Installs - show all installs now and future 
function getInstallCallEntryLogByDate($type,$filter_date) {
	if (strtotime($filter_date) < time()) {
        $sql = "SELECT wo.*, c.address,c.unit_suite,c.vicinity,d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ? AND wo.status = 'in_progress' OR (wo.next_service_date <= ? AND wo.status = 'ongoing') ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
		$tempParams = array($type, $filter_date);
	} else {
        $sql = "SELECT wo.*, c.address,c.unit_suite,c.vicinity,d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ? AND ((wo.service_date = ? AND wo.status = 'in_progress') OR (wo.next_service_date = ? AND wo.status = 'ongoing')) ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
		$tempParams = array($type, $filter_date, $filter_date);
	}
    $params = $tempParams;
   //     $sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND  wo.status = 'unassigned' OR (wo.next_service_date <= ? AND wo.status = 'ongoing')) ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
 
  //  $params = array($type); 
    return preparedSelect($sql, $params);
}
*/
function getInstallCallEntryLogByDateDuo($type1, $filter_date, $type2 = null) {
    if (strtotime($filter_date) < time()) {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            c.vicinity, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE (wo.status = 'in_progress' OR (wo.next_service_date <= ? AND wo.status = 'ongoing'))";

        $params = [$filter_date];

        // Add type filter
        if ($type2 === null) {
            $sql .= " AND wo.type = ?";
            $params[] = $type1;
        } else {
            $sql .= " AND (wo.type = ? OR wo.type = ?)";
            $params[] = $type1;
            $params[] = $type2;
        }

        $sql .= " ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    } else {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            c.vicinity, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE ((wo.service_date = ? AND wo.status = 'in_progress') 
          OR (wo.next_service_date = ? AND wo.status = 'ongoing'))";

        $params = [$filter_date, $filter_date];

        // Add type filter
        if ($type2 === null) {
            $sql .= " AND wo.type = ?";
            $params[] = $type1;
        } else {
            $sql .= " AND (wo.type = ? OR wo.type = ?)";
            $params[] = $type1;
            $params[] = $type2;
        }

        $sql .= " ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    }

    return preparedSelect($sql, $params);
}

/* OLD ONE TYPE */
function getInstallCallEntryLogByDate($type, $filter_date) {
    if (strtotime($filter_date) < time()) {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            c.vicinity, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.type = ? 
          AND (wo.status = 'in_progress' OR (wo.next_service_date <= ? AND wo.status = 'ongoing')) 
        ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";

        $tempParams = array($type, $filter_date);
    } else {
        $sql = "SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            c.vicinity, 
            d.company_name, 
            g.group_id, 
            g.group_title, 
            g.group_color
        FROM WorkOrder AS wo 
        INNER JOIN Customer AS c ON c.id = wo.customer_id 
        LEFT JOIN Company AS d ON d.id = c.company_id 
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.type = ? 
          AND ((wo.service_date = ? AND wo.status = 'in_progress') 
          OR (wo.next_service_date = ? AND wo.status = 'ongoing')) 
        ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";

        $tempParams = array($type, $filter_date, $filter_date);
    }

    $params = $tempParams;
    return preparedSelect($sql, $params);
}








/*BEFORE GROUPS new jobs - gets all "new/unassigned" jobs with install dates and without install dates 
function getCallEntryLogByType($type) {
	$sql = "SELECT wo.*, c.address,c.unit_suite,d.company_name FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN Company AS d ON d.id =  c.company_id WHERE wo.type = ? AND  wo.status = 'new_job' ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";

    $params = array($type);
    return preparedSelect($sql, $params);
} 
*/
/* group check added */
function getCallEntryLogByType($type) {
    $sql = "
        SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
			c.city,
			c.province,
			c.postal,
			c.country,
            d.company_name, 
			g.group_id,
			g.group_title,
            g.group_color
        FROM WorkOrder AS wo
        INNER JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS d ON d.id = c.company_id
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId AND wo.groupId IS NOT NULL AND wo.groupId != ''
        WHERE wo.type = ? 
          AND wo.status = 'new_job'
        ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC
    ";
    $params = array($type);
    return preparedSelect($sql, $params);
}
//DUO 
function getCallEntryLogByTypeDuo($type1, $type2 = null) {
    $sql = "
        SELECT 
            wo.*, 
            c.address, 
            c.unit_suite, 
            c.city,
            c.province,
            c.postal,
            c.country,
            d.company_name, 
            g.group_id,
            g.group_title,
            g.group_color
        FROM WorkOrder AS wo
        INNER JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS d ON d.id = c.company_id
        LEFT JOIN GroupedJobs AS g ON g.group_id = wo.groupId 
            AND wo.groupId IS NOT NULL 
            AND wo.groupId != ''
        WHERE wo.status = 'new_job'";

    $params = [];

    // Add type filter
    if ($type2 === null) {
        $sql .= " AND wo.type = ?";
        $params[] = $type1;
    } else {
        $sql .= " AND (wo.type = ? OR wo.type = ?)";
        $params[] = $type1;
        $params[] = $type2;
    }

    $sql .= " ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";

    return preparedSelect($sql, $params);
}



/* new Service - gets all "new/unassigned" jobs with install dates and without install dates */
function getCallEntryLogByType22($type) {
	$sql = "SELECT wo.*, c.address,c.unit_suite FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND  wo.status = 'new_job' ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
	/*
	if (strtotime($filter_date) < time()) {
        $sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND ((wo.service_date <= ? AND wo.status = 'unassigned') OR (wo.next_service_date <= ? AND wo.status = 'ongoing')) ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    } else {
        $sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = ? AND ((wo.service_date = ? AND wo.status = 'unassigned') OR (wo.next_service_date = ? AND wo.status = 'ongoing')) ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    }
		*/
    $params = array($type);
    return preparedSelect($sql, $params);
}


/* Technical Review */ 
function getCallLogByTypeReview($type) {
	$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo INNER JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.type = 'in_review' AND  wo.status = ? ORDER BY wo.status DESC, wo.priority ASC, wo.time_created ASC";
    $params = array($type);
    return preparedSelect($sql, $params);
}
/*
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper') -- restrict to technician roles
          AND u.id NOT IN (
              SELECT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND COALESCE(wo.service_date, wo.serv_target) <= ?
                AND COALESCE(wo.serv_target, wo.service_date) >= ?
                AND at.active = 1
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate]; // overlap logic: target >= start AND service <= end
    return preparedSelect($sql, $params);
}
*/
/*
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
				COALESCE(NULLIF(wo.serv_target, ''), wo.service_date)

                AND COALESCE(wo.service_date, wo.serv_target) <= ?
                AND COALESCE(wo.serv_target, wo.service_date) >= ?
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate];
    return preparedSelect($sql, $params);
}
	*/
	/*
	function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND COALESCE(NULLIF(wo.service_date, ''), NULLIF(wo.serv_target, ''), wo.service_date) <= ?
                AND COALESCE(NULLIF(wo.serv_target, ''), wo.service_date) >= ?
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate];
    return preparedSelect($sql, $params);
}
*/
/*
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND COALESCE(NULLIF(wo.service_date, ''), wo.serv_target) <= ?
                AND COALESCE(NULLIF(wo.serv_target, ''), wo.service_date) >= ?
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate];
    return preparedSelect($sql, $params);
}
*/
/*
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND COALESCE(NULLIF(wo.service_date, ''), wo.serv_target) <= ?
                AND COALESCE(NULLIF(wo.serv_target, ''), wo.service_date) >= ?
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate];
    return preparedSelect($sql, $params);
}
*/
/*
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT DISTINCT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND (
                    -- Overlap logic: job starts before endDate AND ends after startDate
                    COALESCE(NULLIF(wo.service_date, ''), wo.serv_target) <= ?
                    AND COALESCE(NULLIF(wo.serv_target, ''), wo.service_date) >= ?
                )
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate];
    return preparedSelect($sql, $params);
}
*/

/*
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT DISTINCT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND (
                    -- Safely handle empty or null dates
                    IFNULL(NULLIF(wo.service_date, ''), '0000-00-00') <= ?
                    AND IFNULL(NULLIF(wo.serv_target, ''), IFNULL(NULLIF(wo.service_date, ''), '0000-00-00')) >= ?
                )
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [$endDate, $startDate];
    return preparedSelect($sql, $params);
}
*/





/* main  function used */
function getAvailableTechsForDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT DISTINCT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND (
                    (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
                    OR
                    (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
                )
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate
    ];

    return preparedSelect($sql, $params);
}


function getDoubleBookedTechs($startDate, $endDate, $wo_num, $tech_ids) {
    if (empty($tech_ids)) {
        return [];
    }

    // Create placeholders for technician IDs
    $placeholders = implode(',', array_fill(0, count($tech_ids), '?'));

    $sql = "
        SELECT 
            at.technician_id,
            u.name,
            wo.type,
            wo.wo_number,
            wo.service_date,
            wo.serv_target,
            wo.productionCode
        FROM AssignedTechs at
        JOIN WorkOrder wo ON at.work_order_id = wo.id
        JOIN Users u ON at.technician_id = u.id
        WHERE wo.status = 'in_progress'
          AND at.active = 1
          AND wo.wo_number != ?
          AND at.technician_id IN ($placeholders)
          AND (
              (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= ? AND wo.serv_target >= ?)
              OR
              (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN ? AND ?)
          )
        ORDER BY at.id
    ";

    // Bind parameters: wo_num, tech_ids..., endDate, startDate, startDate, endDate
    $params = array_merge([$wo_num], $tech_ids, [$endDate, $startDate, $startDate, $endDate]);

    return preparedSelect($sql, $params);
}

/*
function getDoubleBookedTechs($startDate, $endDate, $wo_num, $tech_ids) {
    if (empty($tech_ids)) {
        return [];
    }

    // Build placeholders for technician IDs
    $placeholders = implode(',', array_fill(0, count($tech_ids), '?'));

    $sql = "
        SELECT 
            at.technician_id,
            u.name,
            wo.type,
            wo.wo_number,
            wo.service_date,
            wo.serv_target,
            wo.productionCode
        FROM AssignedTechs at
        JOIN WorkOrder wo ON at.work_order_id = wo.id
        JOIN Users u ON at.technician_id = u.id
        WHERE wo.status = 'in_progress'
          AND at.active = 1
          AND wo.wo_number != ?
          AND at.technician_id IN ($placeholders)
          AND (
              (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= ? AND wo.serv_target >= ?)
              OR
              (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN ? AND ?)
          )
        ORDER BY u.name
    ";

    // Bind parameters: wo_num, tech_ids..., endDate, startDate, startDate, endDate
    $params = array_merge([$wo_num], $tech_ids, [$endDate, $startDate, $startDate, $endDate]);

    return preparedSelect($sql, $params);
}
*/
/*
function getDoubleBookedTechs($startDate, $endDate, $wo_num) {
    $sql = "
        SELECT 
            at.technician_id,
            u.name,
            wo.type,
            wo.wo_number,
            wo.service_date,
            wo.serv_target,
            wo.productionCode
        FROM AssignedTechs at
        JOIN WorkOrder wo ON at.work_order_id = wo.id
        JOIN Users u ON at.technician_id = u.id
        WHERE wo.status = 'in_progress'
          AND at.active = 1
          AND wo.wo_number != :wo_num
          AND (
              (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
              OR
              (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
          )
        ORDER BY u.name
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate,
        ':wo_num' => $wo_num
    ];

    return preparedSelect($sql, $params);
}

*/


function getUnassignedTechsByDateRange($startDate, $endDate) {
    $sql = "
        SELECT u.employee_type, u.name
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT DISTINCT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND (
                    (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
                    OR
                    (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
                )
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate
    ];

    return preparedSelect($sql, $params);
}

/*
function getAvailableTechsForDateRange($startDate, $endDate, $excludeWorkOrderId = null) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT DISTINCT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND wo.id != :excludeId
                AND (
                    (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
                    OR
                    (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
                )
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate,
        ':excludeId' => $excludeWorkOrderId ?? 0
    ];

    return preparedSelect($sql, $params);
}
*/
/*
function getAvailableTechsForDateRange($startDate, $endDate, $excludeWorkOrderId = null) {
    $sql = "
        SELECT u.id AS tech_id, u.name, u.phone, u.employee_type
        FROM Users u
        WHERE u.active = 1
          AND u.employee_type IN ('Installer', 'Helper')
          AND u.id NOT IN (
              SELECT DISTINCT at.technician_id
              FROM AssignedTechs at
              JOIN WorkOrder wo ON at.work_order_id = wo.id
              WHERE wo.status = 'in_progress'
                AND at.active = 1
                AND (
                    (
                        wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL
                        AND wo.service_date <= :endDate AND wo.serv_target >= :startDate
                    )
                    OR
                    (
                        wo.service_date IS NOT NULL AND wo.serv_target IS NULL
                        AND wo.service_date BETWEEN :startDate AND :endDate
                    )
                )
                " . ($excludeWorkOrderId ? "AND wo.id != :excludeId" : "") . "
          )
        ORDER BY FIELD(u.employee_type, 'Installer', 'Helper'), u.name
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate
    ];

    if ($excludeWorkOrderId) {
        $params[':excludeId'] = $excludeWorkOrderId;
    }

    return preparedSelect($sql, $params);
}
newest broken*/

/*
function getCalendarInProgressJobs() {
    // Calculate date range
    $startDate = date('Y-m-01'); // First day of current month
    $endDate = date('Y-m-t', strtotime('+1 month')); // Last day of next month

    $sql = "
        SELECT wo.*, c.address, comp.name AS company_name
        FROM WorkOrder AS wo
        LEFT JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS comp ON comp.id = c.company_id
        LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id
        WHERE wo.status = 'in_progress'
          AND at.active = 1
          AND (
              (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
              OR
              (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
          )
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate
    ];

    return preparedSelect($sql, $params);
}
*/
/* dates and array()
function getCalendarInProgressJobs() {
    // Define date range: current month to end of next month
    $startDate = date('Y-m-01'); // First day of current month
    $endDate = date('Y-m-t', strtotime('+1 month')); // Last day of next month

    $sql = "
        SELECT 
            wo.id AS work_order_id,
            wo.service_date,
            wo.serv_target,
            wo.status,
            c.address,
            comp.name AS company_name,
            at.technician_id,
            u.name AS technician_name,
            u.employee_type
        FROM WorkOrder AS wo
        JOIN AssignedTechs AS at ON at.work_order_id = wo.id AND at.active = 1
        JOIN Users AS u ON u.id = at.technician_id AND u.active = 1
        LEFT JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS comp ON comp.id = c.company_id
        WHERE wo.status = 'in_progress'
          AND (
              (
                  wo.service_date IS NOT NULL
                  AND (
                      (wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
                      OR
                      (wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
                  )
              )
              OR
              (wo.service_date IS NULL AND wo.serv_target IS NULL)
          )
        ORDER BY wo.service_date ASC, wo.id
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate
    ];

   // return preparedSelect($sql, $params);

 $jobs = preparedSelect($sql, $params);

    return [
        'startDate' => $startDate,
        'endDate' => $endDate,
        'jobs' => $jobs
    ];
}
*/
/*
function getCalendarInProgressJobs() {
    $startDate = date('Y-m-01');
    $endDate = date('Y-m-t', strtotime('+1 month'));

    $sql = "
        SELECT 
            wo.id AS work_order_id,
            wo.service_date,
            wo.serv_target,
            wo.status,
            c.address,
            comp.name AS company_name,
            at.technician_id,
            u.name AS technician_name,
            u.employee_type
        FROM WorkOrder AS wo
        JOIN AssignedTechs AS at ON at.work_order_id = wo.id AND at.active = 1
        JOIN Users AS u ON u.id = at.technician_id AND u.active = 1
        LEFT JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS comp ON comp.id = c.company_id
        WHERE wo.status = 'in_progress'
          AND (
              (
                  wo.service_date IS NOT NULL
                  AND (
                      (wo.serv_target IS NOT NULL AND wo.service_date <= :endDate AND wo.serv_target >= :startDate)
                      OR
                      (wo.serv_target IS NULL AND wo.service_date BETWEEN :startDate AND :endDate)
                  )
              )
              OR
              (wo.service_date IS NULL AND wo.serv_target IS NULL)
          )
    ";

    $params = [
        ':startDate' => $startDate,
        ':endDate' => $endDate
    ];

    $jobs = preparedSelect($sql, $params);

    return [
        'startDate' => $startDate,
        'endDate' => $endDate,
        'jobs' => $jobs
    ];
}
*/
/*
function getCalendarInProgressJobs() {
    $startDate = date('Y-m-01'); // First day of current month
    $endDate = date('Y-m-t', strtotime('+1 month')); // Last day of next month

    $sql = "
        SELECT 
            wo.id AS work_order_id,
            wo.service_date,
            wo.serv_target,
            wo.status,
            c.address,
            comp.name AS company_name,
            at.technician_id,
            u.name AS technician_name,
            u.employee_type
        FROM WorkOrder AS wo
        JOIN AssignedTechs AS at ON at.work_order_id = wo.id AND at.active = 1
        JOIN Users AS u ON u.id = at.technician_id AND u.active = 1
        LEFT JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS comp ON comp.id = c.company_id
        WHERE wo.status = 'in_progress'
          AND (
              (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= ? AND wo.serv_target >= ?)
              OR
              (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN ? AND ?)
              OR
              (wo.service_date IS NULL AND wo.serv_target IS NULL)
          )
    ";

    $params = [$endDate, $startDate, $startDate, $endDate];

    $jobs = preparedSelect($sql, $params);

    return [
        'startDate' => $startDate,
        'endDate' => $endDate,
        'jobs' => $jobs
    ];
}
*/


/*excelente 
function getCalendarInProgressJobs() {
    $startDate = date('Y-m-01'); // First day of current month
    $endDate = date('Y-m-t', strtotime('+1 month')); // Last day of next month

    $sql = "
        SELECT 
            wo.id AS work_order_id,
            wo.service_date,
            wo.serv_target,
            wo.productionCode,
			wo.type,
            c.address,
            c.unit_suite,
            comp.company_name,
            GROUP_CONCAT(u.name SEPARATOR ', ') AS technician_names
        FROM WorkOrder AS wo
        JOIN AssignedTechs AS at ON at.work_order_id = wo.id AND at.active = 1
        JOIN Users AS u ON u.id = at.technician_id AND u.active = 1
        LEFT JOIN Customer AS c ON c.id = wo.customer_id
        LEFT JOIN Company AS comp ON comp.id = c.company_id
        WHERE wo.status = 'in_progress'
          AND (
              (wo.service_date IS NOT NULL AND wo.serv_target IS NOT NULL AND wo.service_date <= ? AND wo.serv_target >= ?)
              OR
              (wo.service_date IS NOT NULL AND wo.serv_target IS NULL AND wo.service_date BETWEEN ? AND ?)
              OR
              (wo.service_date IS NULL AND wo.serv_target IS NULL)
          )
        GROUP BY wo.id, wo.service_date, wo.serv_target, wo.status, c.address, c.unit_suite, comp.company_name
    ";

    $params = [$endDate, $startDate, $startDate, $endDate];

    $jobs = preparedSelect($sql, $params);

    return [
        'startDate' => $startDate,
        'endDate' => $endDate,
        'jobs' => $jobs
    ];
}
excellente */

/*
function getCalendarInProgressJobs() {
    // first day of this month, last day of next month
    //$startDate = date('Y-m-01');
	$startDate = date('Y-m-01', strtotime('-1 month'));
    $endDate   = date('Y-m-t', strtotime('+1 month'));

    $sql = "
      SELECT
        wo.id               AS work_order_id,
		wo.wo_number,
        wo.service_date,
        wo.serv_target,
		wo.priority,
        wo.productionCode,
        wo.type,
        c.address,
        c.unit_suite,
        comp.company_name,
        -- if no techs, return empty string instead of NULL
        COALESCE(
          GROUP_CONCAT(u.name ORDER BY u.name SEPARATOR ', '),
          ''
        ) AS technician_names
      FROM WorkOrder AS wo

      -- LEFT JOIN so orders without techs still appear
      LEFT JOIN AssignedTechs AS at
        ON at.work_order_id = wo.id
        AND at.active = 1

      LEFT JOIN Users AS u
        ON u.id       = at.technician_id
        AND u.active  = 1

      LEFT JOIN Customer AS c
        ON c.id = wo.customer_id

      LEFT JOIN Company AS comp
        ON comp.id = c.company_id

     WHERE wo.status IN ('new_job', 'in_review', 'in_production', 'in_progress')

	   AND wo.priority != 5
        AND (
          (wo.service_date IS NOT NULL
           AND wo.serv_target IS NOT NULL
           AND wo.service_date <= ?
           AND wo.serv_target >= ?)
          OR
          (wo.service_date IS NOT NULL
           AND wo.serv_target IS NULL
           AND wo.service_date BETWEEN ? AND ?)
          OR
          (wo.service_date IS NULL
           AND wo.serv_target IS NULL)
        )

      GROUP BY wo.id
    ";

    $params = [
      $endDate,
      $startDate,
      $startDate,
      $endDate
    ];

    $jobs = preparedSelect($sql, $params);

    return [
      'startDate' => $startDate,
      'endDate'   => $endDate,
      'jobs'      => $jobs
    ];
}
*/


function getCalendarJobs() {
    $startDate = date('Y-m-01', strtotime('-1 month'));
    $endDate   = date('Y-m-t', strtotime('+1 month'));

    $sql = "
      SELECT
        wo.id               AS work_order_id,
        wo.wo_number,
        wo.service_date,
        wo.serv_target,
        wo.priority,
        wo.productionCode,
        wo.type,
        c.address,
        c.unit_suite,
        comp.company_name,
        gj.group_color,
        COALESCE(
          GROUP_CONCAT(u.name ORDER BY u.name SEPARATOR ', '),
          ''
        ) AS technician_names
      FROM WorkOrder AS wo

      LEFT JOIN AssignedTechs AS at
        ON at.work_order_id = wo.id
        AND at.active = 1

      LEFT JOIN Users AS u
        ON u.id = at.technician_id
        AND u.active = 1

      LEFT JOIN Customer AS c
        ON c.id = wo.customer_id

      LEFT JOIN Company AS comp
        ON comp.id = c.company_id

      LEFT JOIN GroupedJobs AS gj
        ON gj.group_id = wo.groupId

      WHERE wo.status IN ('new_job', 'in_review', 'in_production', 'in_progress')
        AND wo.priority != 5
        AND wo.tentative_service_date = 0
        AND (wo.groupId IS NULL OR wo.group_active = 1)
        AND (
          (wo.service_date IS NOT NULL
           AND wo.serv_target IS NOT NULL
           AND wo.service_date <= ?
           AND wo.serv_target >= ?)
          OR
          (wo.service_date IS NOT NULL
           AND wo.serv_target IS NULL
           AND wo.service_date BETWEEN ? AND ?)
          OR
          (wo.service_date IS NULL
           AND wo.serv_target IS NULL)
        )

      GROUP BY wo.id
    ";

    $params = [
      $endDate,
      $startDate,
      $startDate,
      $endDate
    ];

    $jobs = preparedSelect($sql, $params);

    return [
      'startDate' => $startDate,
      'endDate'   => $endDate,
      'jobs'      => $jobs
    ];
}



function getCurrentJobsForTechs($tech) {
	$sql = "SELECT wo.*, c.address, c.unit_suite FROM WorkOrder AS wo LEFT JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id WHERE at.technician_id = ? AND wo.status = 'in_progress' AND at.active = 1 ORDER BY wo.service_date ASC";
	$params = array($tech);
	return preparedSelect($sql, $params);
}

function getCurrentJobs($tech) {
	$sql = "SELECT wo.*, c.address, c.unit_suite FROM WorkOrder AS wo LEFT JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id WHERE at.technician_id = ? && wo.status = 'in_progress' AND at.active";
	$params = array($tech);
	return preparedSelect($sql, $params);
}

function getCurrentJobs2($tech) {
	$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo LEFT JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id WHERE at.technician_id = ? && wo.status IN ('in_progress','ongoing') AND at.active";
	$params = array($tech);
	return preparedSelect($sql, $params);
}

function getCurrentJobs3($tech) {
	$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo LEFT JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id WHERE at.technician_id = ? && wo.status = 'ongoing' AND at.active";
	$params = array($tech);
	return preparedSelect($sql, $params);
}

function getCurrentJobsReview($tech) {
	$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo LEFT JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id WHERE at.technician_id = ? && wo.status = 'in_review' AND at.active";
	$params = array($tech);
	return preparedSelect($sql, $params);
}

function getCompletedJobs($tech) {
	$sql = "SELECT wo.*, c.address FROM WorkOrder AS wo LEFT JOIN Customer AS c ON c.id = wo.customer_id LEFT JOIN AssignedTechs AS at ON at.work_order_id = wo.id WHERE at.technician_id = ? && wo.status = 'complete' OR wo.status = 'ready_for_pricing' ORDER BY wo.time_completed DESC";
	$params = array($tech);
	return preparedSelect($sql, $params);
}

function getTechnicians($type) {
	$sql = "SELECT * FROM Users WHERE type = 'technician' AND (employee_type = ? OR employee_type = 'Apprentice') AND active = 1 ORDER BY employee_type, `name`";
	$params = array($type);
	return preparedSelect($sql, $params);
}

function getAllTechnicians() {
	$sql = "SELECT * FROM Users WHERE type = 'technician' AND active = 1 ORDER BY employee_type, `name`";
	//$sql = "SELECT * FROM Users WHERE type = 'technician' AND active = 1 ORDER BY CASE WHEN employee_type = 'Plumbing' THEN 'Electric' ELSE 'Apprentice' END, `name`";
	//CASE WHEN city = 'New York' THEN 1 ELSE 2 END
	return simpleSelect($sql);
}

function getTechnician($id) {
	$sql = "SELECT * FROM Users WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function updateAssignedTechnician($at_id, $tech_id, $active) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE AssignedTechs SET technician_id = ?, active = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $tech_id, PDO::PARAM_INT);
		$stmt->bindParam(2, $active, PDO::PARAM_INT);
		$stmt->bindParam(3, $at_id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function updateAssignedTechnicianLabour($wo_id, $old_tech, $new_tech) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE TimeCards SET technician_id = ? WHERE work_order_id = ? AND technician_id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $new_tech, PDO::PARAM_INT);
		$stmt->bindParam(2, $wo_id, PDO::PARAM_INT);
		$stmt->bindParam(3, $old_tech, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
//here
function getAssignedTechnicians($id) {
	$sql = "SELECT a.id 'at_id', a.active 'active', u.id 'tech_id', u.name 'name', u.phone 'phone', u.employee_type 'employee_type', u.active 'active_user'
		FROM Users u 
			LEFT JOIN AssignedTechs a 
				ON a.technician_id = u.id 
		WHERE a.work_order_id = ?
		ORDER BY a.id";
	$params = array($id);
	return preparedSelect($sql, $params);
}
function getAssignedTechniciansActive($id){
	$sql = "SELECT a.id 'at_id', a.active 'active', u.id 'tech_id', u.name 'name', u.phone 'phone', u.employee_type 'employee_type', u.active 'active_user'
		FROM Users u 
			LEFT JOIN AssignedTechs a 
				ON a.technician_id = u.id 
		WHERE a.work_order_id = ? AND u.active = 1
		ORDER BY a.id";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function getAssignedTechniciansActivePlay($id) {
    //global $pdo;
$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Step 1: Get service date range of the current work order
    $dateStmt = $pdo->prepare("SELECT service_date, serv_target FROM WorkOrder WHERE id = ?");
    $dateStmt->execute([$id]);
    $dateRange = $dateStmt->fetch(PDO::FETCH_ASSOC);

    if (!$dateRange) return [];

    $startDate = $dateRange['service_date'];
    $endDate = $dateRange['serv_target'];

    // Step 2: Get all technicians assigned to this work order
    $techStmt = $pdo->prepare("
        SELECT 
            a.id AS at_id,
            a.active AS active,
            u.id AS tech_id,
            u.name AS name,
            u.phone AS phone,
            u.employee_type AS employee_type,
            u.active AS active_user
        FROM Users u
        LEFT JOIN AssignedTechs a ON a.technician_id = u.id
        WHERE a.work_order_id = ? AND u.active = 1
        ORDER BY a.id
    ");
    $techStmt->execute([$id]);
    $technicians = $techStmt->fetchAll(PDO::FETCH_ASSOC);

    // Step 3: For each technician, check if they are assigned to any other work order in the same date range
    foreach ($technicians as &$tech) {
        $checkStmt = $pdo->prepare("
            SELECT COUNT(*) FROM AssignedTechs at
            JOIN WorkOrder wo ON at.work_order_id = wo.id
            WHERE at.technician_id = ?
              AND wo.id != ? -- exclude current work order
              AND wo.service_date <= ?
              AND wo.serv_target >= ?
        ");
        $checkStmt->execute([
            $tech['tech_id'],
            $id,
            $endDate,
            $startDate
        ]);
        $isAssigned = $checkStmt->fetchColumn() > 0;
        $tech['is_assigned_in_range'] = $isAssigned;
    }

    return $technicians;
}

/* used on inProgress.php & to display tech names by type  plumber/electric/apprentice  */
function getAssignedTechniciansByTypePlumbing($id) {
	$sql = "SELECT a.id 'at_id', a.active 'active', u.id 'tech_id', u.name 'name', u.phone 'phone', u.employee_type 'employee_type', u.active 'active_user'
		FROM Users u 
		LEFT JOIN AssignedTechs a 
				ON a.technician_id = u.id 
		WHERE a.work_order_id = ?
ORDER BY
   CASE WHEN u.employee_type = 'Istaller' THEN 0
        WHEN u.employee_type = 'Electric' THEN 1
        WHEN u.employee_type = 'Apprentice' THEN 2
   END,a.id";
	$params = array($id);
	return preparedSelect($sql, $params);
}
/* used on inProgressInstalls.php & to display tech names by type  Installer  */
function getAssignedTechniciansNew($id) {
	$sql = "SELECT a.id 'at_id', a.active 'active', u.id 'tech_id', u.name 'name', u.phone 'phone', u.employee_type 'employee_type', u.active 'active_user'
		FROM Users u 
		LEFT JOIN AssignedTechs a 
				ON a.technician_id = u.id 
		WHERE a.work_order_id = ?
ORDER BY
   CASE WHEN u.employee_type = 'Istaller' THEN 0
        WHEN u.employee_type = 'Helper' THEN 1
   END,a.id";
	$params = array($id);
	return preparedSelect($sql, $params);
}
/* used on inProgress.php & to display tech names by type  electric/plumber/apprentice */
function getAssignedTechniciansByTypeElectric($id) {
	$sql = "SELECT a.id 'at_id', a.active 'active', u.id 'tech_id', u.name 'name', u.phone 'phone', u.employee_type 'employee_type', u.active 'active_user'
		FROM Users u 
			LEFT JOIN AssignedTechs a 
				ON a.technician_id = u.id 
		WHERE a.work_order_id = ?
ORDER BY
   CASE WHEN u.employee_type = 'Electric' THEN 0
        WHEN u.employee_type = 'Plumbing' THEN 1
        WHEN u.employee_type = 'Apprentice' THEN 2
   END,a.id";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function cancelWorkOrder($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'cancelled' WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function assignTech($workOrderId, $techId, $active) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO AssignedTechs(work_order_id, technician_id, active) VALUES(?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $workOrderId, PDO::PARAM_INT);
		$stmt->bindParam(2, $techId, PDO::PARAM_INT);
		$stmt->bindParam(3, $active, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
function swapTech($workOrderId, $techId, $active, $old_tech_id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		//$sql = "UPDATE AssignedTechs SET (work_order_id, technician_id, active) VALUES(?, ?, ?) WHERE ";
		$sql = "UPDATE AssignedTechs SET technician_id = ?, active = ? WHERE work_order_id = ? AND technician_id = ?";
		$stmt = $pdo->prepare($sql);



		$stmt->bindParam(1, $techId, PDO::PARAM_INT);
		$stmt->bindParam(2, $active, PDO::PARAM_INT);
		$stmt->bindParam(3, $workOrderId, PDO::PARAM_INT);
		$stmt->bindParam(4, $old_tech_id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


function unassignAllTechs($wo_id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM AssignedTechs WHERE work_order_id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $wo_id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function unassignTech($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM AssignedTechs WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function removeTimeCards($wo_id, $tech_id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM TimeCards WHERE work_order_id = ? AND technician_id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $wo_id, PDO::PARAM_INT);
		$stmt->bindParam(2, $tech_id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function removeAllTimeCards($wo_id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM TimeCards WHERE work_order_id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $wo_id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function assignCall($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_progress', time_assigned = now() WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function unassignCall($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'unassigned' WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function insertToBeScheduled($type, $customer_id, $unit, $reported) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrderUnscheduled(type, customer_id, unit, work_required) VALUES(?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $customer_id, PDO::PARAM_INT);
		$stmt->bindParam(3, $unit, PDO::PARAM_STR);
		$stmt->bindParam(4, $reported, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function insertCall($type, $number, $service_date, $customer_id, $unit, $po, $reported, $priority) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number, service_date, customer_id, unit, po, work_required, priority) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);
		$stmt->bindParam(3, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(4, $customer_id, PDO::PARAM_INT);
		$stmt->bindParam(5, $unit, PDO::PARAM_STR);
		$stmt->bindParam(6, $po, PDO::PARAM_STR);
		$stmt->bindParam(7, $reported, PDO::PARAM_STR);
		$stmt->bindParam(8, $priority, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

/* without service date */

function insertDatelessCall($type, $number, $customer_id, $unit, $po, $reported, $priority) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number,  customer_id, unit, po, work_required, priority) VALUES(?, ?, ?, ?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);
		$stmt->bindParam(3, $customer_id, PDO::PARAM_INT);
		$stmt->bindParam(4, $unit, PDO::PARAM_STR);
		$stmt->bindParam(5, $po, PDO::PARAM_STR);
		$stmt->bindParam(6, $reported, PDO::PARAM_STR);
		$stmt->bindParam(7, $priority, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

/* new jobs */
/* REPLACED has tentative_service_date     */             
function insertJob($type, $number, $service_date, $customer_id, $unit, $po, $required, $status, $priority, $designer, $notes, $serv_type, $serv_arrival, $serv_target, $companyId, $tentative_service_date) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number, service_date, customer_id, unit, po, work_required, status, priority, designer, notes, service_type, serv_arrival, serv_target, companyId, tentative_service_date) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);
		$stmt->bindParam(3, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(4, $customer_id, PDO::PARAM_INT);
		$stmt->bindParam(5, $unit, PDO::PARAM_STR);
		$stmt->bindParam(6, $po, PDO::PARAM_STR);
		$stmt->bindParam(7, $required, PDO::PARAM_STR);
		$stmt->bindParam(8, $status, PDO::PARAM_STR);
		$stmt->bindParam(9, $priority, PDO::PARAM_STR);
		$stmt->bindParam(10, $designer, PDO::PARAM_STR);
		$stmt->bindParam(11, $notes, PDO::PARAM_STR);
		$stmt->bindParam(12, $serv_type, PDO::PARAM_STR);
		$stmt->bindParam(13, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(14, $serv_target, PDO::PARAM_STR);
		$stmt->bindParam(15, $companyId, PDO::PARAM_INT);
        $stmt->bindParam(16, $tentative_service_date, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

/*
function insertJob($type, $number, $service_date, $customer_id, $unit, $po, $required, $status, $priority, $designer, $notes, $serv_type, $serv_arrival, $serv_target, $companyId) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number, service_date, customer_id, unit, po, work_required, status, priority, designer, notes, service_type, serv_arrival, serv_target, companyId) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);
		$stmt->bindParam(3, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(4, $customer_id, PDO::PARAM_INT);
		$stmt->bindParam(5, $unit, PDO::PARAM_STR);
		$stmt->bindParam(6, $po, PDO::PARAM_STR);
		$stmt->bindParam(7, $required, PDO::PARAM_STR);
		$stmt->bindParam(8, $status, PDO::PARAM_STR);
		$stmt->bindParam(9, $priority, PDO::PARAM_STR);
		$stmt->bindParam(10, $designer, PDO::PARAM_STR);
		$stmt->bindParam(11, $notes, PDO::PARAM_STR);
		$stmt->bindParam(12, $serv_type, PDO::PARAM_STR);
		$stmt->bindParam(13, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(14, $serv_target, PDO::PARAM_STR);
		$stmt->bindParam(15, $companyId, PDO::PARAM_INT);

		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}
*/	
/* without service date */

function insertDatelessJob($type, $number, $customer_id, $unit, $po, $required, $status, $priority, $designer, $notes) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number,  customer_id, unit, po, work_required, status, priority, designer, notes) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);
		$stmt->bindParam(3, $customer_id, PDO::PARAM_INT);
		$stmt->bindParam(4, $unit, PDO::PARAM_STR);
		$stmt->bindParam(5, $po, PDO::PARAM_STR);
		$stmt->bindParam(6, $required, PDO::PARAM_STR);
		$stmt->bindParam(7, $status, PDO::PARAM_STR);
		$stmt->bindParam(8, $priority, PDO::PARAM_STR);
        $stmt->bindParam(9, $designer, PDO::PARAM_STR);
		$stmt->bindParam(10, $notes, PDO::PARAM_STR);

		


		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			//$last_id = $pdo->lastInsertId();
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

/* service call new */

// insertNewServiceCall($TYPE, $NUMBER, $SERVICE_DATE, $CUSTOMER_ID, $PO, $REQUIRED, $STATUS, $PRIORITY, $NOTES, $SERV_ARRIVAL, $SERV_TARGET, $COMPANY_ID);
function insertNewServiceCall($type, $number, $service_date, $customer_id, $po, $required, $status, $priority, $notes, $serv_arrival, $serv_target, $companyId, $tentative_service_date) {
	$type = "Service";
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number, service_date, customer_id, po, work_required, status, priority, notes,  serv_arrival, serv_target, companyId,tentative_service_date) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);  // last wo_num + 1
		$stmt->bindParam(3, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(4, $customer_id, PDO::PARAM_INT);
		//$stmt->bindParam(5, $unit, PDO::PARAM_STR);
		$stmt->bindParam(5, $po, PDO::PARAM_STR);
		$stmt->bindParam(6, $required, PDO::PARAM_STR);
		$stmt->bindParam(7, $status, PDO::PARAM_STR);
		$stmt->bindParam(8, $priority, PDO::PARAM_STR);
		//$stmt->bindParam(10, $designer, PDO::PARAM_STR);
		$stmt->bindParam(9, $notes, PDO::PARAM_STR);
		//$stmt->bindParam(12, $serv_type, PDO::PARAM_STR);
		$stmt->bindParam(10, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(11, $serv_target, PDO::PARAM_STR);
		$stmt->bindParam(12, $companyId, PDO::PARAM_INT);
		$stmt->bindParam(13, $tentative_service_date, PDO::PARAM_INT);

		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

/*hardware insert */

//insertNewHardwareOrder($TYPE, $NUMBER, $SERVICE_DATE, $CUSTOMER_ID, $PO, $REQUIRED, $STATUS, $PRIORITY, $NOTES, $SERV_ARRIVAL, $SERV_TARGET, $COMPANY_ID, $SERV_TYPE);;
function insertNewHardwareOrder($type, $number, $service_date, $customer_id, $po, $required, $status, $priority, $notes, $serv_arrival, $serv_target, $companyId, $serv_type) {
	$type = "Hardware";
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO WorkOrder(type, wo_number, service_date, customer_id, po, work_required, status, priority, notes,  serv_arrival, serv_target, companyId, service_type) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $type, PDO::PARAM_STR);
		$stmt->bindParam(2, $number, PDO::PARAM_STR);  // last wo_num + 1
		$stmt->bindParam(3, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(4, $customer_id, PDO::PARAM_INT);
		//$stmt->bindParam(5, $unit, PDO::PARAM_STR);
		$stmt->bindParam(5, $po, PDO::PARAM_STR);
		$stmt->bindParam(6, $required, PDO::PARAM_STR);
		$stmt->bindParam(7, $status, PDO::PARAM_STR);
		$stmt->bindParam(8, $priority, PDO::PARAM_STR);
		//$stmt->bindParam(10, $designer, PDO::PARAM_STR);
		$stmt->bindParam(9, $notes, PDO::PARAM_STR);
		//$stmt->bindParam(12, $serv_type, PDO::PARAM_STR);
		$stmt->bindParam(10, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(11, $serv_target, PDO::PARAM_STR);
		$stmt->bindParam(12, $companyId, PDO::PARAM_INT);
		$stmt->bindParam(13, $serv_type, PDO::PARAM_STR);

		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

 //updateNewJob($WO_NUM, $SERVICE_DATE, $UNIT, $REQUIRED, $PRIORITY, $NOTES, $addressList, $DESIGNER,$SERV_TYPE,$SERV_ARRIVAL,$SERV_TARGET,$PO, $companyList, $TYPE ,$tentative_service_date);
function updateNewJob($WO_NUM, $SERVICE_DATE, $UNIT, $REQUIRED, $PRIORITY, $NOTES, $addressList, $DESIGNER, $SERV_TYPE, $SERV_ARRIVAL, $SERV_TARGET,$PO, $companyId, $TYPE ,$tentative_service_date) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, unit = ?, work_required = ?, priority = ?, notes = ?, customer_id = ?, designer = ?, service_type = ?, serv_arrival = ?, serv_target = ?, po = ?, companyId = ?, type = ?, tentative_service_date = ? WHERE wo_number = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $SERVICE_DATE, PDO::PARAM_STR);
		$stmt->bindParam(2, $UNIT, PDO::PARAM_STR);
		$stmt->bindParam(3, $REQUIRED, PDO::PARAM_STR);
		$stmt->bindParam(4, $PRIORITY, PDO::PARAM_STR);
		$stmt->bindParam(5, $NOTES, PDO::PARAM_STR);
		$stmt->bindParam(6, $addressList, PDO::PARAM_INT);
		$stmt->bindParam(7, $DESIGNER, PDO::PARAM_STR);
		$stmt->bindParam(8, $SERV_TYPE, PDO::PARAM_STR);
		$stmt->bindParam(9, $SERV_ARRIVAL, PDO::PARAM_STR);
		$stmt->bindParam(10, $SERV_TARGET, PDO::PARAM_STR);
		$stmt->bindParam(11, $PO, PDO::PARAM_STR);
        $stmt->bindParam(12, $companyId, PDO::PARAM_INT);
		$stmt->bindParam(13, $TYPE, PDO::PARAM_STR);
        $stmt->bindParam(14, $tentative_service_date, PDO::PARAM_INT);
		$stmt->bindParam(15, $WO_NUM, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


function updateNewHardwareOrder($WO_NUM, $SERVICE_DATE, $REQUIRED, $PRIORITY, $NOTES, $addressList, $SERV_ARRIVAL, $SERV_TARGET,$PO, $companyId, $service_type) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, work_required = ?, priority = ?, notes = ?, customer_id = ?, serv_arrival = ?, serv_target = ?, po = ?, companyId = ?, service_type = ? WHERE wo_number = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $SERVICE_DATE, PDO::PARAM_STR);
	//	$stmt->bindParam(2, $UNIT, PDO::PARAM_STR);
		$stmt->bindParam(2, $REQUIRED, PDO::PARAM_STR);
		$stmt->bindParam(3, $PRIORITY, PDO::PARAM_STR);
		$stmt->bindParam(4, $NOTES, PDO::PARAM_STR);
		$stmt->bindParam(5, $addressList, PDO::PARAM_INT);
	//	$stmt->bindParam(7, $DESIGNER, PDO::PARAM_STR);
	//	$stmt->bindParam(8, $service_type, PDO::PARAM_STR);
		$stmt->bindParam(6, $SERV_ARRIVAL, PDO::PARAM_STR);
		$stmt->bindParam(7, $SERV_TARGET, PDO::PARAM_STR);
		$stmt->bindParam(8, $PO, PDO::PARAM_STR);
        $stmt->bindParam(9, $companyId, PDO::PARAM_INT);
		$stmt->bindParam(10, $service_type, PDO::PARAM_STR);
		$stmt->bindParam(11, $WO_NUM, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


/* ServiceCall update */
function updateNewServiceCall($WO_NUM, $SERVICE_DATE, $REQUIRED, $PRIORITY, $NOTES, $addressList, $SERV_ARRIVAL, $SERV_TARGET,$PO, $companyId,$tentative_service_date) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, work_required = ?, priority = ?, notes = ?, customer_id = ?, serv_arrival = ?, serv_target = ?, po = ?, companyId = ?,tentative_service_date = ? WHERE wo_number = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $SERVICE_DATE, PDO::PARAM_STR);
	//	$stmt->bindParam(2, $UNIT, PDO::PARAM_STR);
		$stmt->bindParam(2, $REQUIRED, PDO::PARAM_STR);
		$stmt->bindParam(3, $PRIORITY, PDO::PARAM_STR);
		$stmt->bindParam(4, $NOTES, PDO::PARAM_STR);
		$stmt->bindParam(5, $addressList, PDO::PARAM_INT);
	//	$stmt->bindParam(7, $DESIGNER, PDO::PARAM_STR);
	//	$stmt->bindParam(8, $SERV_TYPE, PDO::PARAM_STR);
		$stmt->bindParam(6, $SERV_ARRIVAL, PDO::PARAM_STR);
		$stmt->bindParam(7, $SERV_TARGET, PDO::PARAM_STR);
		$stmt->bindParam(8, $PO, PDO::PARAM_STR);
        $stmt->bindParam(9, $companyId, PDO::PARAM_INT);
		$stmt->bindParam(10, $tentative_service_date, PDO::PARAM_INT);
		$stmt->bindParam(11, $WO_NUM, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}



function updateCall($id, $service_date, $unit, $po, $reported, $priority) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, unit = ?, po = ?, priority = ?, work_required = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(2, $unit, PDO::PARAM_STR);
		$stmt->bindParam(3, $po, PDO::PARAM_STR);
		$stmt->bindParam(4, $priority, PDO::PARAM_STR);
		$stmt->bindParam(5, $reported, PDO::PARAM_STR);
		$stmt->bindParam(6, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}
function updateInstallCall($id, $service_date, $priority, $reported) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(2, $priority, PDO::PARAM_STR);
		$stmt->bindParam(3, $reported, PDO::PARAM_STR);
		$stmt->bindParam(4, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

//new
 	function updateInstallCallXtra($id, $service_date, $priority, $reported, $arrivalTime, $targetDate, $initialNotes, $addressNotes, $customer_id) {
 try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Begin transaction
        $pdo->beginTransaction();

        // First update: ProgressTracking
       	$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ?, serv_arrival = ?, serv_target = ?, notes = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(2, $priority, PDO::PARAM_INT);
		$stmt->bindParam(3, $reported, PDO::PARAM_STR);
		$stmt->bindParam(4, $arrivalTime, PDO::PARAM_STR);
		$stmt->bindParam(5, $targetDate, PDO::PARAM_STR);
		$stmt->bindParam(6, $initialNotes, PDO::PARAM_STR);
		$stmt->bindParam(7, $id, PDO::PARAM_INT);
		$stmt->execute();

        // Second update: WorkOrder
        $sql2 = "UPDATE Customer SET address_notes = ? WHERE id = ?";
        $stmt2 = $pdo->prepare($sql2);
		$stmt2->bindParam(1, $addressNotes, PDO::PARAM_STR);
        $stmt2->bindParam(2, $customer_id, PDO::PARAM_INT);
        $stmt2->execute();

        // Commit transaction
        $pdo->commit();

        return true;

    } catch(PDOException $e) {
        if ($pdo && $pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo "Transaction failed: " . $e->getMessage();
        return false;
    } finally {
        $pdo = null;
    }
	}
/*
function updateInstallCallXtra($id, $service_date, $priority, $reported, $arrivalTime, $targetDate, $initialNotes, $addressNotes) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ?, serv_arrival = ?, serv_target = ?, notes = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
		$stmt->bindParam(2, $priority, PDO::PARAM_INT);
		$stmt->bindParam(3, $reported, PDO::PARAM_STR);
		$stmt->bindParam(4, $arrivalTime, PDO::PARAM_STR);
		$stmt->bindParam(5, $targetDate, PDO::PARAM_STR);
		$stmt->bindParam(6, $initialNotes, PDO::PARAM_STR);
		$stmt->bindParam(7, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}
*/

function hideShowTech($wo_id, $tech_id, $at_active) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE AssignedTechs SET active = ? WHERE work_order_id = ? AND technician_id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $at_active, PDO::PARAM_INT);
		$stmt->bindParam(2, $wo_id, PDO::PARAM_INT);
		$stmt->bindParam(3, $tech_id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}





function updateUnscheduled($id, $unit, $reported) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrderUnscheduled SET unit = ?, work_required = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $unit, PDO::PARAM_STR);
		$stmt->bindParam(2, $reported, PDO::PARAM_STR);
		$stmt->bindParam(3, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function getCustomer($id) {
	$sql = "SELECT * FROM Customer WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}
/* oiriginal 
function getCustomerSuggestions($code) {
	$sql = "SELECT c1.id, ccode, address,unit_suite
	FROM Customer c1
    	LEFT JOIN Company c2
        	ON c1.company_id = c2.id
	WHERE c2.onhold = 0 AND c1.active = 1 AND (ccode LIKE ? OR address LIKE ?)
    LIMIT 6";
	$params = array("%$code%", "%$code%");
	return preparedSelect($sql, $params);
}
*/




/* oiriginal but only search ccode*/
function getCustomerSuggestions($code) {
	$sql = "SELECT c1.id, ccode, address,unit_suite
	FROM Customer c1
    	LEFT JOIN Company c2
        	ON c1.company_id = c2.id
	WHERE c2.onhold = 0 AND c1.active = 1 AND (ccode LIKE ?)
    LIMIT 6";
	$params = array("%$code%");
	return preparedSelect($sql, $params);
}

function getHardwareSuggestions($symbol) {
    $sql = "SELECT id, symbol, description, unit, pk_unit, entity, entity_order
            FROM HardwareList
            WHERE symbol LIKE ?
            LIMIT 10";
    $params = array("%$symbol%");
    return preparedSelect($sql, $params);
}


/* Include all matches regardless if there's a ccode*
function getCustomerSuggestions($code) {
	$sql = "SELECT c1.id, ccode, address
	FROM Customer c1
    	LEFT JOIN Company c2
        	ON c1.company_id = c2.id
	WHERE c2.onhold = 0 AND c1.active = 1 AND (ccode LIKE ? OR address LIKE ?)
    LIMIT 6";
	$params = array("$code%", "%$code%");
	return preparedSelect($sql, $params);
}
/
/* multi-field search ??? one letter?
function getCustomerSuggestions($code) {
    $sql = "SELECT c1.id, ccode, address,unit_suite
    FROM Customer c1
    LEFT JOIN Company c2 ON c1.company_id = c2.id
    WHERE c2.onhold = 0 
      AND c1.active = 1 
      AND (
        (ccode LIKE ? AND TRIM(ccode) != '' AND ccode IS NOT NULL)
        OR 
        (address LIKE ? AND TRIM(address) != '' AND address IS NOT NULL)
      )
    LIMIT 6";

    $params = array("$code%", "%$code%");
    return preparedSelect($sql, $params);
}
*/


/* only existing results with ccode -- not working?
function getCustomerSuggestions($code) {
    $sql = "SELECT c1.id, ccode, address
    FROM Customer c1
    LEFT JOIN Company c2 ON c1.company_id = c2.id
    WHERE c2.onhold = 0 
      AND c1.active = 1 
      AND ccode LIKE ? 
      AND TRIM(ccode) != '' 
      AND ccode IS NOT NULL
    LIMIT 6";

    $params = array("$code%");
    return preparedSelect($sql, $params);
}
*/

function updateTechnicalReview($id,$service_date,$unit,$priority,$designer,$productionCode,$prod_notes,$technicalReviewBy,$technicalReviewByDate,$optimization,$optimizationDate,$productionScheduling,$productionSchedulingDate,$inventoryDeductions,$inventoryDeductionsDate,$reviewCompleted,$project_received_date) {

$criteraComplete = 1;	

if(mb_strlen($productionCode, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($prod_notes, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($technicalReviewBy, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($technicalReviewByDate, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($optimization, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($optimizationDate, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($productionScheduling, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($productionSchedulingDate, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($inventoryDeductions, 'UTF-8') < 2){ $criteraComplete = 0; };
if(mb_strlen($inventoryDeductionsDate, 'UTF-8') < 2){ $criteraComplete = 0; };

$reviewCompleted = $criteraComplete;

	
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?,unit = ?,priority = ?,designer = ?,productionCode = ?,prod_notes = ?,technicalReviewBy = ?,technicalReviewByDate = ?,optimization = ?,optimizationDate = ?,productionScheduling = ?,productionSchedulingDate = ?,inventoryDeductions = ?,inventoryDeductionsDate = ?,review_completed = ?, project_received_date = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1,$service_date, PDO::PARAM_STR);
		$stmt->bindParam(2,$unit, PDO::PARAM_STR);
		$stmt->bindParam(3,$priority, PDO::PARAM_INT);
		                         
		$stmt->bindParam(4,$designer, PDO::PARAM_STR);
		$stmt->bindParam(5,$productionCode, PDO::PARAM_INT);
		$stmt->bindParam(6,$prod_notes, PDO::PARAM_STR);
		$stmt->bindParam(7,$technicalReviewBy, PDO::PARAM_STR);
		$stmt->bindParam(8,$technicalReviewByDate, PDO::PARAM_STR);
		$stmt->bindParam(9,$optimization, PDO::PARAM_STR);
		$stmt->bindParam(10,$optimizationDate, PDO::PARAM_STR);
		$stmt->bindParam(11,$productionScheduling, PDO::PARAM_STR);
		$stmt->bindParam(12,$productionSchedulingDate, PDO::PARAM_STR); 
		$stmt->bindParam(13,$inventoryDeductions, PDO::PARAM_STR);
		$stmt->bindParam(14,$inventoryDeductionsDate, PDO::PARAM_STR);
		$stmt->bindParam(15,$reviewCompleted, PDO::PARAM_INT);
        $stmt->bindParam(16,$project_received_date, PDO::PARAM_STR);
		$stmt->bindParam(17,$id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}




/*
function getWorkOrder($id) {
try {
	$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
	$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
	$query = $pdo->prepare("SELECT c.*, wo.* FROM WorkOrder as wo LEFT JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.id = :kundencode");
	$query->bindValue('kundencode',$id);
	$query->execute();
	//$stmt->bindParam(1,$id,PDO::PARAM_STR);
//	$stmt = $pdo->prepare($sql);
//	$stmt1->query($stmt1);
	//return $query->fetchAll();

	//return $query->fetchAll(PDO::FETCH_ASSOC);
	return $query->fetchAll();
} catch (Exception $ex) {
	echo "DB Exception: " . $ex->getMessage();
	return null;
} finally {
	$pdo = null;
}
}


*/
/*
function getWorkOrdersX($id) {

	//$sql = "SELECT c.*, wo.* FROM WorkOrder as wo LEFT JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.id = ?";
	//$params = array($id);
//array_push($params,$id);
	//$params = array_fill($id);
	$sql = "SELECT c.*, wo.* 
	        FROM WorkOrder 
			as wo	
            LEFT JOIN Customer AS c			
			ON c.id = wo.customer_id
			WHERE wo.service_date >= CURDATE() AND wo.service_date < DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 2 MONTH) ";

	$params = array();
	//echo 'ok -> '.$params[0];
	//print_r($sql);

	$params = array($id);
	return preparedSelect($sql, $params);
}
*/
/*

SELECT * FROM your_table_name 
WHERE 
service_date >= CURDATE() 
AND service_date < DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 2 MONTH) 
AND active = TRUE

*/

function getWorkOrderBasic($id){
	$sql = "SELECT * FROM WorkOrder WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);

}

function getWorkOrder($id) {

	//$sql = "SELECT c.*, wo.* FROM WorkOrder as wo LEFT JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.id = ?";
	//$params = array($id);
//array_push($params,$id);
	//$params = array_fill($id);
	$sql = "SELECT c.*, wo.* 
	        FROM WorkOrder 
			as wo	
            LEFT JOIN Customer AS c			
			ON c.id = wo.customer_id
			WHERE wo.id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}




function getInProgressWorkOrder($id) {
	
	$sql = "SELECT c.*, wo.* FROM WorkOrder as wo LEFT JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.id = ? AND wo.status = 'in_progress'";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function getProductionInfo($id) {
	$sql = "SELECT * FROM ProgressTracking WHERE wo_number_track = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function getProductionStatus($id) {
	$sql = "SELECT * FROM ProgressTracking WHERE wo_number_track = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function addProductionParams($woNum, $divisionType, $totalStages) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO ProgressTracking (wo_number_track, type_division, total_stages) VALUES(?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $woNum, PDO::PARAM_INT);
		$stmt->bindParam(2, $divisionType, PDO::PARAM_STR);
		$stmt->bindParam(3, $totalStages, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function setProductionStatus($id) {
	/* UPDATE WorkOder.  */
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET  production_completed = ?,  WHERE wo_number = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $all_stages_completed, PDO::PARAM_INT);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}

}

function getUnscheduled($id) {
	$sql = "SELECT c.*, wo.* FROM WorkOrderUnscheduled wo LEFT JOIN Customer c ON c.id = wo.customer_id WHERE wo.id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function deleteUnscheduled($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM WorkOrderUnscheduled WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

/* used in call history for pop up*/
function getWorkOrderId($wo_number) {
	$sql = "SELECT id FROM WorkOrder WHERE wo_number = ?";
	$params = array($wo_number);
	return preparedSelect($sql, $params);
}
/* used for New Job */
function getWorkOrderNew($id) {

	//$sql = "SELECT c.*, wo.* FROM WorkOrder as wo LEFT JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.id = ?";
	//$params = array($id);
//array_push($params,$id);
	//$params = array_fill($id);
	/*
	
	c2.company_name
SELECT c.*, wo.*, c2.company_name 'company'
	*/

	$sql = "SELECT c.*, wo.*, c2.company_name 'company'
	        FROM WorkOrder 
			as wo	
            LEFT JOIN Customer AS c			
			ON c.id = wo.customer_id
			LEFT JOIN Company c2
					ON c.company_id = c2.id
			WHERE wo.id = ?";

	$params = array($id);
	//echo 'ok -> '.$params[0];
	//print_r($sql);

	$params = array($id);
	return preparedSelect($sql, $params);
}

//
function getWorkOrderDetail($id) {
	$sql = "
			SELECT c.*, wo.*, c2.company_name 'company', c2.id 'companyId', c2.address1 'billing_address1', c2.address2 'billing_address2', c2.city 'billing_city', c2.province 'billing_province', c2.postal 'billing_postal', c2.p_rate 'p_rate', c2.e_rate 'e_rate', c2.h_rate 'h_rate', t.name, t.phone, t.employee_type 
			FROM WorkOrder wo 
				LEFT JOIN Customer c 
					ON c.id = wo.customer_id 
				LEFT JOIN Company c2
					ON c.company_id = c2.id
				LEFT JOIN AssignedTechs at 
					ON at.work_order_id = wo.id
				LEFT JOIN Users t 
					ON t.id = at.technician_id 
			WHERE wo.id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}
function getProductionWorkOrderDetail($id) {
	$sql = "
			SELECT c.*, wo.*, c2.company_name 'company', c2.address1 'billing_address1', c2.address2 'billing_address2', c2.city 'billing_city', c2.province 'billing_province', c2.postal 'billing_postal', c2.p_rate 'p_rate', c2.e_rate 'e_rate', c2.h_rate 'h_rate', t.name, t.phone, t.employee_type 
			FROM WorkOrder wo 
				LEFT JOIN Customer c 
					ON c.id = wo.customer_id 
				LEFT JOIN Company c2
					ON c.company_id = c2.id
				LEFT JOIN AssignedTechs at 
					ON at.work_order_id = wo.id
				LEFT JOIN Users t 
					ON t.id = at.technician_id 
			WHERE wo.id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

//  $id,$formNotes,$sigName,$formNotesTarget,$sigTarget
function updateStageInfo($id,$formNotes,$sigName,$stageNumber){
	//$formNotesTarget = "notes_" . $stageNumber;
   // $sigTarget = "signature_" . $stageNumber;
   $formNotesTarget = "notes_".$stageNumber;
    $sigTarget = "signature_".$stageNumber;
	$updateDate = "last_updated_".$stageNumber;
	$t = time();
	
		try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE ProgressTracking SET ".$formNotesTarget." = ?, ".$sigTarget." = ? WHERE wo_number_track = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $formNotes, PDO::PARAM_STR);
		$stmt->bindParam(2, $sigName, PDO::PARAM_STR);
		$stmt->bindParam(3, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


/* coPilot
function updateStageProgress($id, $stageNum, $stageStatus, $stageNumOld, $newStageNum, $all_stages_completed) {
    $stageTarget = "stage_" . $stageNum;
    $statusSetTime = date("Y-m-d H:i:s");

    if ($stageStatus === "Completed") {
        $targetStageMain = $newStageNum;
        $statusSetTimeTarget = "stage_" . $stageNum . "_time_completed";
    } else {
        $targetStageMain = $stageNum;
        $statusSetTimeTarget = "stage_" . $stageNum . "_time_started";
    }

    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Begin transaction
        $pdo->beginTransaction();

        // Update ProgressTracking
        $sql1 = "UPDATE ProgressTracking SET $stageTarget = ?, current_stage = ?, all_stages_completed = ?, $statusSetTimeTarget = ? WHERE wo_number_track = ?";
        $stmt1 = $pdo->prepare($sql1);
        $stmt1->execute([$stageStatus, $newStageNum, $all_stages_completed, $statusSetTime, $id]);

        // Update WorkOrder
        $sql2 = "UPDATE WorkOrder SET current_production_stage = ?, prod_stage_status = ?, production_completed = ? WHERE wo_number = ?";
        $stmt2 = $pdo->prepare($sql2);
        $stmt2->execute([$targetStageMain, $stageStatus, $all_stages_completed, $id]);

        // Fetch updated row from ProductionTracking
        $sql3 = "SELECT * FROM ProductionTracking WHERE wo_number_track = ?";
        $stmt3 = $pdo->prepare($sql3);
        $stmt3->execute([$id]);
        $updatedRow = $stmt3->fetch(PDO::FETCH_ASSOC);

        // Commit all changes
        $pdo->commit();

        return $updatedRow;

    } catch (PDOException $e) {
        if ($pdo && $pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo "Transaction failed: " . $e->getMessage();
        return false;
    } finally {
        $pdo = null;
    }
}
*/




function updateStageProgress($id, $stageNum, $stageStatus, $stageNumOld, $newStageNum, $all_stages_completed) {
    $stageTarget = "stage_" . $stageNum;
	//$targetStageMain = "";
	$statusSetTime = date("Y-m-d H:i:s");
	$newStageStatus = $stageStatus;
	if($stageStatus === "Completed" && $stageNum < 4){
$newStageStatus = "Not Started";
	}	

if($stageStatus === "Completed"){
	$targetStageMain = $newStageNum;
	$statusSetTimeTarget = "stage_".$stageNum."_time_completed";
}else{
	$targetStageMain = $stageNum;
	$statusSetTimeTarget = "stage_".$stageNum."_time_started";
} 
if($all_stages_completed === 1){

$returnStartTime = "";
$returnCompletedTime = "";

}
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Begin transaction
        $pdo->beginTransaction();

        // First update: ProgressTracking
        $sql1 = "UPDATE ProgressTracking SET " . $stageTarget . " = ?, current_stage = ?, all_stages_completed = ?, " . $statusSetTimeTarget . " =? WHERE wo_number_track = ?";
        $stmt1 = $pdo->prepare($sql1);
        $stmt1->bindParam(1, $stageStatus, PDO::PARAM_STR);
        $stmt1->bindParam(2, $newStageNum, PDO::PARAM_INT);
        $stmt1->bindParam(3, $all_stages_completed, PDO::PARAM_INT);
        $stmt1->bindParam(4, $statusSetTime, PDO::PARAM_STR);
        $stmt1->bindParam(5, $id, PDO::PARAM_INT);
        $stmt1->execute();

        // Second update: WorkOrder
        $sql2 = "UPDATE WorkOrder SET current_production_stage = ?, prod_stage_status = ?, production_completed = ? WHERE wo_number = ?";
        $stmt2 = $pdo->prepare($sql2);
		$stmt2->bindParam(1, $targetStageMain, PDO::PARAM_STR);
		$stmt2->bindParam(2, $newStageStatus, PDO::PARAM_STR);
        $stmt2->bindParam(3, $all_stages_completed, PDO::PARAM_INT);
        $stmt2->bindParam(4, $id, PDO::PARAM_INT);
        $stmt2->execute();

        // Commit transaction
        $pdo->commit();

        return true;

    } catch(PDOException $e) {
        if ($pdo && $pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo "Transaction failed: " . $e->getMessage();
        return false;
    } finally {
        $pdo = null;
    }
}


function updateStageProgressDoors($id, $stageNum, $stageStatus, $stageNumOld, $newStageNum, $all_stages_completed) {
    $stageTarget = "stage_" . $stageNum;
	//$targetStageMain = "";
	$statusSetTime = date("Y-m-d H:i:s");
	$newStageStatus = $stageStatus;
	if($stageStatus === "Completed" && $stageNum < 3){
$newStageStatus = "Not Started";
	}	

if($stageStatus === "Completed"){
	$targetStageMain = $newStageNum;
	$statusSetTimeTarget = "stage_".$stageNum."_time_completed";
}else{
	$targetStageMain = $stageNum;
	$statusSetTimeTarget = "stage_".$stageNum."_time_started";
} 
if($all_stages_completed === 1){

$returnStartTime = "";
$returnCompletedTime = "";

}
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Begin transaction
        $pdo->beginTransaction();

        // First update: ProgressTracking
        $sql1 = "UPDATE ProgressTracking SET " . $stageTarget . " = ?, current_stage = ?, all_stages_completed = ?, " . $statusSetTimeTarget . " =? WHERE wo_number_track = ?";
        $stmt1 = $pdo->prepare($sql1);
        $stmt1->bindParam(1, $stageStatus, PDO::PARAM_STR);
        $stmt1->bindParam(2, $newStageNum, PDO::PARAM_INT);
        $stmt1->bindParam(3, $all_stages_completed, PDO::PARAM_INT);
        $stmt1->bindParam(4, $statusSetTime, PDO::PARAM_STR);
        $stmt1->bindParam(5, $id, PDO::PARAM_INT);
        $stmt1->execute();

        // Second update: WorkOrder
        $sql2 = "UPDATE WorkOrder SET current_production_stage = ?, prod_stage_status = ?, production_completed = ? WHERE wo_number = ?";
        $stmt2 = $pdo->prepare($sql2);
		$stmt2->bindParam(1, $targetStageMain, PDO::PARAM_STR);
		$stmt2->bindParam(2, $newStageStatus, PDO::PARAM_STR);
        $stmt2->bindParam(3, $all_stages_completed, PDO::PARAM_INT);
        $stmt2->bindParam(4, $id, PDO::PARAM_INT);
        $stmt2->execute();

        // Commit transaction
        $pdo->commit();

        return true;

    } catch(PDOException $e) {
        if ($pdo && $pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo "Transaction failed: " . $e->getMessage();
        return false;
    } finally {
        $pdo = null;
    }
}






// set Stage progress info in WorkOrder
function updateStageProgressWorkOrder($id,$stageStatusNewText,$stageNum,$all_stages_completed){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET  prod_stage = ?, prod_stage_status = ?, production_completed = ?,  WHERE wo_number = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $stageNum, PDO::PARAM_INT);
		$stmt->bindParam(2, $stageStatusNewText, PDO::PARAM_INT);
		$stmt->bindParam(3, $all_stages_completed, PDO::PARAM_INT);
		$stmt->bindParam(4, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
   
}

/*
function updateStageProgress($id, $stageNum, $stageStatus,$stageNumOld,$newStageNum,$all_stages_completed){
 $stageTarget = "stage_".$stageNum;


		try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE ProgressTracking SET ".$stageTarget." = ?, current_stage = ?, all_stages_completed = ? WHERE wo_number_track = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $stageStatus, PDO::PARAM_STR);
		$stmt->bindParam(2, $newStageNum, PDO::PARAM_INT);
		$stmt->bindParam(3, $all_stages_completed, PDO::PARAM_INT);
		$stmt->bindParam(4, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

*/


function setProductionStagesCompleted($id,$all_stages_completed){
			try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET  production_completed = ?,  WHERE wo_number = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $all_stages_completed, PDO::PARAM_INT);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


// not used but maybe called
function getWorkOrderRates($id) {
	$sql = "SELECT c2.p_rate, c2.e_rate, c2.h_rate
			FROM WorkOrder wo
				LEFT JOIN Customer c1
					ON wo.customer_id = c1.id
				LEFT JOIN Company c2
					ON c1.company_id = c2.id
			WHERE wo.id = ?";
	$params = array($id);
	return preparedSelect($sql, $params)[0];
}

//here added $work_required for admin to update from Ready For Pricing (updateWorkOrder.php)
// need new function for Ready For Pricing (updateWorkOrder.php) that includes $work_required
function updateWorkOrder($id, $unit, $po, $work_required, $work_performed, $quote, $cod, $recall, $extra, $status, $job_complete, $total_materials, $total_labour, $total_tax) {
// NEW function updateWorkOrderFull($id, $unit, $po, $work_required, $work_performed, $quote, $cod, $recall, $extra, $status, $job_complete, $total_materials, $total_labour, $total_tax) {
	
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET unit = ?, po = ?,work_required = ?, work_completed = ?, quote = ?, cod = ?, recall = ?, extra = ?, status = ?, job_complete = ?, total_materials = ?, total_labour = ?, total_tax = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $unit, PDO::PARAM_STR);
		$stmt->bindParam(2, $po, PDO::PARAM_STR);
		$stmt->bindParam(3, $work_required, PDO::PARAM_STR);
		$stmt->bindParam(4, $work_performed, PDO::PARAM_STR);
		$stmt->bindParam(5, $quote, PDO::PARAM_INT);
		$stmt->bindParam(6, $cod, PDO::PARAM_INT);
		$stmt->bindParam(7, $recall, PDO::PARAM_INT);
		$stmt->bindParam(8, $extra, PDO::PARAM_INT);
		$stmt->bindParam(9, $status, PDO::PARAM_STR);
		$stmt->bindParam(10, $job_complete, PDO::PARAM_INT);
		$stmt->bindParam(11, $total_materials, PDO::PARAM_STR);
		$stmt->bindParam(12, $total_labour, PDO::PARAM_STR);
		$stmt->bindParam(13, $total_tax, PDO::PARAM_STR);
		$stmt->bindParam(14, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateWorkOrderInstalls($id, $service_date, $priority, $work_required, $work_performed, $status, $job_complete, $total_materials, $total_labour, $total_tax, $serv_target, $serv_arrival){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ?, work_completed = ?, status = ?, job_complete = ?, total_materials = ?, total_labour = ?, total_tax = ?, serv_target = ?, serv_arrival = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
	    $stmt->bindParam(2, $priority, PDO::PARAM_INT);
		$stmt->bindParam(3, $work_required, PDO::PARAM_STR);
		$stmt->bindParam(4, $work_performed, PDO::PARAM_STR);
		$stmt->bindParam(5, $status, PDO::PARAM_STR);
		$stmt->bindParam(6, $job_complete, PDO::PARAM_INT);
		$stmt->bindParam(7, $total_materials, PDO::PARAM_STR);
		$stmt->bindParam(8, $total_labour, PDO::PARAM_STR);
		$stmt->bindParam(9, $total_tax, PDO::PARAM_STR);
        $stmt->bindParam(10, $serv_target, PDO::PARAM_STR);
        $stmt->bindParam(11, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(12, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}
//updateWorkOrderShipping.php
function updateWorkOrderShipping($id, $service_date, $priority, $work_required, $work_performed, $status, $job_complete, $total_materials, $total_labour, $total_tax, $serv_target, $serv_arrival){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ?, work_completed = ?, status = ?, job_complete = ?, total_materials = ?, total_labour = ?, total_tax = ?, serv_target = ?, serv_arrival = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
	    $stmt->bindParam(2, $priority, PDO::PARAM_INT);
		$stmt->bindParam(3, $work_required, PDO::PARAM_STR);
		$stmt->bindParam(4, $work_performed, PDO::PARAM_STR);
		$stmt->bindParam(5, $status, PDO::PARAM_STR);
		$stmt->bindParam(6, $job_complete, PDO::PARAM_INT);
		$stmt->bindParam(7, $total_materials, PDO::PARAM_STR);
		$stmt->bindParam(8, $total_labour, PDO::PARAM_STR);
		$stmt->bindParam(9, $total_tax, PDO::PARAM_STR);
        $stmt->bindParam(10, $serv_target, PDO::PARAM_STR);
        $stmt->bindParam(11, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(12, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

//updateWorkOrderDelivery.php
function updateWorkOrderDelivery($id, $service_date, $priority, $work_required, $work_performed, $status, $job_complete, $total_materials, $total_labour, $total_tax, $serv_target, $serv_arrival){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ?, work_completed = ?, status = ?, job_complete = ?, total_materials = ?, total_labour = ?, total_tax = ?, serv_target = ?, serv_arrival = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
	    $stmt->bindParam(2, $priority, PDO::PARAM_INT);
		$stmt->bindParam(3, $work_required, PDO::PARAM_STR);
		$stmt->bindParam(4, $work_performed, PDO::PARAM_STR);
		$stmt->bindParam(5, $status, PDO::PARAM_STR);
		$stmt->bindParam(6, $job_complete, PDO::PARAM_INT);
		$stmt->bindParam(7, $total_materials, PDO::PARAM_STR);
		$stmt->bindParam(8, $total_labour, PDO::PARAM_STR);
		$stmt->bindParam(9, $total_tax, PDO::PARAM_STR);
        $stmt->bindParam(10, $serv_target, PDO::PARAM_STR);
        $stmt->bindParam(11, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(12, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

//updateWorkOrderPickup.php
function updateWorkOrderPickup($id, $service_date, $priority, $work_required, $work_performed, $status, $job_complete, $total_materials, $total_labour, $total_tax, $serv_target, $serv_arrival){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ?, priority = ?, work_required = ?, work_completed = ?, status = ?, job_complete = ?, total_materials = ?, total_labour = ?, total_tax = ?, serv_target = ?, serv_arrival = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $service_date, PDO::PARAM_STR);
	    $stmt->bindParam(2, $priority, PDO::PARAM_INT);
		$stmt->bindParam(3, $work_required, PDO::PARAM_STR);
		$stmt->bindParam(4, $work_performed, PDO::PARAM_STR);
		$stmt->bindParam(5, $status, PDO::PARAM_STR);
		$stmt->bindParam(6, $job_complete, PDO::PARAM_INT);
		$stmt->bindParam(7, $total_materials, PDO::PARAM_STR);
		$stmt->bindParam(8, $total_labour, PDO::PARAM_STR);
		$stmt->bindParam(9, $total_tax, PDO::PARAM_STR);
        $stmt->bindParam(10, $serv_target, PDO::PARAM_STR);
        $stmt->bindParam(11, $serv_arrival, PDO::PARAM_STR);
		$stmt->bindParam(12, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateServiceDate($id, $srvc) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_date = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $srvc, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateServiceArrivalTime($id, $srvc) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET serv_arrival = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $srvc, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateServiceTargetDate($id, $srvc) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET serv_target = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $srvc, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateServiceType($id, $fld) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_type = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $fld, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

/* check if in_installs and change the "status" e.g. "in_shipping"  */
function updateServiceTypeAndStatus($id, $fld,$serviceTypeStr) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET service_type = ?, status = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $fld, PDO::PARAM_STR);
		$stmt->bindParam(2, $serviceTypeStr, PDO::PARAM_STR);
		$stmt->bindParam(3, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


function updateTargetProdCompletedDate($id, $targetDate) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET productionSchedulingDate = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $targetDate, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

// targetCompleteDate
function updateEstFinishDate($id, $estDate) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET est_service_finish = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $estDate, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


function updateTentativeStartDate($id, $tVal) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET tentative_service_date = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $tVal, PDO::PARAM_INT);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


function updatePO($id, $po) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET po = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $po, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updatePriority($id, $priority) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET priority = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $priority, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateType($id, $divisionType) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET type = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $divisionType, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateWorkRequired($id, $workRequired) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET work_required = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $workRequired, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}



function updateNotes($id, $notes) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET notes  = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $notes, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


function updateTimeCompleted($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET time_completed = now() WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}


function updateHardwareOrderItem($id, $newQuantity, $newShipQuantity, $newBOQuantity) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE HardwareItemsUsed SET quantity = ?, qty_ship = ?, qty_BO = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $newQuantity, PDO::PARAM_INT);
		$stmt->bindParam(2, $newShipQuantity, PDO::PARAM_INT);
		$stmt->bindParam(3, $newBOQuantity, PDO::PARAM_INT);
		$stmt->bindParam(4, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}



function getMaterials($id) {
	$sql = "SELECT * FROM MaterialsUsed WHERE work_order_id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}
/*
function getFullHardwareList() {
	$sql = "SELECT * FROM HardwareList";
	return simpleSelect($sql);
}
*/

function getHardwareList() {
	$sql = "SELECT * FROM HardwareList";
	//$params = array($id);
	return preparedSelect($sql,[]);
}

// items ordered by WorkOrder.id (an order)
function getHardwareOrderList($work_order_id) {
	$sql = "SELECT * FROM HardwareItemsUsed WHERE work_order_id = ?";
	$params = array($work_order_id);
	return preparedSelect($sql,$params);
}

function getHardwareItem($id) {
	$sql = "SELECT * FROM HardwareList WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

// quantity, symbol, material, unit, work_order_id, qty_ship, qty_BO, cost_per_unit, material_status, other 
// // $quantity, $symbol, $material, $unit, $work_order_id, $qty_ship, $qty_BO, $cost_per_unit, $material_status, $other 
function addHardwareOrderItem($quantity, $symbol, $material, $unit, $work_order_id, $qty_ship, $qty_BO, $cost_per_unit, $material_status, $other) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO HardwareItemsUsed (quantity,symbol,material,unit,work_order_id, qty_ship,qty_BO,cost_per_unit,material_status,other) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $quantity, PDO::PARAM_INT);
		$stmt->bindParam(2, $symbol, PDO::PARAM_STR);
		$stmt->bindParam(3, $material, PDO::PARAM_STR);
		$stmt->bindParam(4, $unit, PDO::PARAM_STR);
        $stmt->bindParam(5, $work_order_id, PDO::PARAM_INT);
        $stmt->bindParam(6, $qty_ship, PDO::PARAM_INT);
		$stmt->bindParam(7, $qty_BO, PDO::PARAM_INT);
		$stmt->bindParam(8, $cost_per_unit, PDO::PARAM_STR);
        $stmt->bindParam(9, $material_status, PDO::PARAM_INT);
		$stmt->bindParam(10, $other, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

//Hardware
function deleteOrderItem($id) {
      try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM HardwareItemsUsed WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


function insertMaterial($quantity, $item, $cost, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO MaterialsUsed (quantity, material, cost_per_unit, work_order_id) VALUES(?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $quantity, PDO::PARAM_INT);
		$stmt->bindParam(2, $item, PDO::PARAM_STR);
		$stmt->bindParam(3, $cost, PDO::PARAM_STR);
		$stmt->bindParam(4, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateMaterial($id, $quantity, $item, $cost) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE MaterialsUsed SET quantity = ?, material = ?, cost_per_unit = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $quantity, PDO::PARAM_INT);
		$stmt->bindParam(2, $item, PDO::PARAM_STR);
		$stmt->bindParam(3, $cost, PDO::PARAM_STR);
		$stmt->bindParam(4, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function deleteMaterial($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM MaterialsUsed WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


function getLabour($id) {
	$sql = "SELECT tc.id, tc.date, DATE_FORMAT(tc.time_in, '%H:%i') time_in, DATE_FORMAT(tc.time_out, '%H:%i') time_out, tc.overtime, tc.rate, tc.technician_id 'tech_id', u.name 
		FROM TimeCards AS tc 
			LEFT JOIN Users AS u 
				ON u.id = tc.technician_id 
		WHERE tc.work_order_id = ? 
		ORDER BY tc.date, tc.technician_id, tc.time_in ASC";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function insertLabour($id, $tech, $date, $time_in, $time_out, $ot, $rate) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO TimeCards (`date`, time_in, time_out, overtime, work_order_id, technician_id, rate) VALUES (?, ?, ?, ?, ?, ?, ?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $date, PDO::PARAM_STR);
		$stmt->bindParam(2, $time_in, PDO::PARAM_STR);
		$stmt->bindParam(3, $time_out, PDO::PARAM_STR);
		$stmt->bindParam(4, $ot, PDO::PARAM_INT);
		$stmt->bindParam(5, $id, PDO::PARAM_INT);
		$stmt->bindParam(6, $tech, PDO::PARAM_INT);
		$stmt->bindParam(7, $rate, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function updateLabour($id, $tech, $date, $time_in, $time_out, $ot, $rate) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE TimeCards  SET `date` = ?, time_in = ?, time_out = ?, technician_id = ?, overtime = ?, `rate` = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $date, PDO::PARAM_STR);
		$stmt->bindParam(2, $time_in, PDO::PARAM_STR);
		$stmt->bindParam(3, $time_out, PDO::PARAM_STR);
		$stmt->bindParam(4, $tech, PDO::PARAM_INT);
		$stmt->bindParam(5, $ot, PDO::PARAM_INT);
		$stmt->bindParam(6, $rate, PDO::PARAM_STR);
		$stmt->bindParam(7, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}	
}

function deleteLabour($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM TimeCards WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function getAllTimeSheets($week) {
	$sql = "SELECT u.name 'tech_name', tc.work_order_id, wo.wo_number, tc.date, DATE_FORMAT(tc.time_in, '%H:%i') time_in, DATE_FORMAT(tc.time_out, '%H:%i') time_out, tc.overtime, c.address
			FROM TimeCards tc 
				LEFT JOIN Users u
					ON tc.technician_id = u.id
				LEFT JOIN WorkOrder wo 
					ON tc.work_order_id = wo.id 
				LEFT JOIN Customer c 
					ON c.id = wo.customer_id 
				WHERE WEEK(`date`, 1) = ?
				ORDER BY 'tech_name', tc.date";
	$params = array($week);
	return preparedSelect($sql, $params);
}

function getTimeSheet($id, $year, $week) {
	$sql = "SELECT u.name 'tech_name', tc.work_order_id, wo.wo_number, wo.productionCode, tc.date, DATE_FORMAT(tc.time_in, '%H:%i') time_in, DATE_FORMAT(tc.time_out, '%H:%i') time_out, tc.overtime, c.address
			FROM TimeCards tc 
				LEFT JOIN Users u
					ON tc.technician_id = u.id
				LEFT JOIN WorkOrder wo 
					ON tc.work_order_id = wo.id 
				LEFT JOIN Customer c 
					ON c.id = wo.customer_id 
				WHERE technician_id = ? AND YEARWEEK(`date`, 1) = ?
				ORDER BY tc.date, tc.time_in";
	$params = array($id, $year . $week);
	return preparedSelect($sql, $params);
}

function unCompleteWorkOrder($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'ready_for_pricing', printed = 0 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function sendWorkOrderBack($id, $status) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = ?, printed = 0 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $status, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

/* SETTERS */
function setComplete($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'complete', job_complete = 1, time_completed = NOW()  WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


function setTechnicalReview($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_review', time_completed = NULL WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

//current_production_stage = ?, prod_stage_status = ?, production_completed = ? WHERE wo_number = ?
function setProduction($id) {
$review_completed_date = date("Y-m-d H:i:s");
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_production', time_completed = NULL, current_production_stage = 1, prod_stage_status = 'Not Started', production_completed = 0, review_completed_date = ?  WHERE id = ?";
		$stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $review_completed_date, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

//bypass 'unassigned' installs.php to 'in_progress' new installs.php
function setInstalls($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_progress' WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function setShipping($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_shipping' WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
function setDelivery($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_delivery' WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
function setPickup($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_pickup' WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

//sendBack > Completed - New Orders
function setHardware($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'new_job', job_complete = 0  WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}




//current_production_stage
function setProductionStartedGlobal($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_progress', time_completed = NULL WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function setInProgress($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_progress', time_completed = NULL WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function setOngoing($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'ongoing', next_service_date = null WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function unsetOngoing($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET status = 'in_progress', next_service_date = null WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function getBatchOrders($type, $start, $end) {
	$sql = "SELECT wo.id, wo_number, c1.ccode, c1.address, c2.company_name, total_materials, total_labour, total_tax, (total_materials + total_labour + total_tax) 'total'
			FROM WorkOrder wo
				JOIN Customer c1
					ON wo.customer_id = c1.id
			    JOIN Company c2
			    	ON c1.company_id = c2.id
			WHERE type = ? AND status = 'complete' AND (service_date >= ? AND service_date <= ?)
			ORDER BY wo_number";
	$params = array($type, $start, $end);
	return preparedSelect($sql, $params);
}

function getAllUnprinted($type) {
	$sql = "SELECT wo.id, wo_number, c1.ccode, c1.address, c2.company_name, total_materials, total_labour, total_tax, (total_materials + total_labour + total_tax) 'total'
			FROM WorkOrder wo
				JOIN Customer c1
					ON wo.customer_id = c1.id
			    JOIN Company c2
			    	ON c1.company_id = c2.id
			WHERE type = ? AND status = 'complete' AND printed = 0
			ORDER BY wo_number";
	$params = array($type);
	return preparedSelect($sql, $params);
}

function setPrinted($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET printed = 1 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function setFiled($id,$filled) {
	if($filled == 0){
		$filled = 1;
	}else{
		$filled = 0;
	}
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET printed = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $filled, PDO::PARAM_INT);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function setEmailed($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET receipt_emailed = 1 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function getAddressBook() {
	$sql = "SELECT c1.*, c2.company_name, c2.onhold FROM Customer c1 LEFT JOIN Company c2 ON c1.company_id = c2.id WHERE c1.active = 1";
	return simpleSelect($sql);
}

function exportAddressBook() {
	try {
		$sql = '
			SELECT
				c1.id,
				c1.ccode,
				c1.address,
				c1.city,
				c1.province,
				c1.postal,
				c1.vicinity,
				c1.contact_name,
				c1.contact_phone,
				c1.contact_cell,
				c1.contact_email,
				c1.pm_name,
				c1.pm_phone,
				c1.pm_cell,
				c1.pm_email,
				c1.notes,
				c1.billing_name,
				c2.company_name
			FROM Customer c1
			LEFT JOIN Company c2
				ON c1.company_id = c2.id
			WHERE c1.active AND NOT c2.onhold
		';
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        //Step 2 - establish database connection
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        //Step 3 - execute an SQL statement
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        //Step 4 - process the query results
        return $stmt;
    } catch (Exception $ex) {
        echo "DB Exception: " . $ex->getMessage();
        return null;
    } finally {
        //Step 5 - close your database connection
        $pdo = null;
    }
}

function getAddress($id) {
	$sql = "SELECT * FROM Customer WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}
function getCustomerAddress($id) {
	$sql = "SELECT * FROM Customer WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}
function getCustomerAddresses($id) {
	$sql = "SELECT * FROM Customer WHERE company_id = ? AND ACTIVE = 1";
	//return simpleSelect($sql);
	$params = array($id);
	return preparedSelect($sql, $params);
}

function insertAddress($code, $address, $postal, $city, $province, $vicinity, $name, $phone, $cell, $email, $pm, $pm_phone, $pm_cell, $pm_email, $notes, $billing_name, $company, $suite) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO Customer(ccode, address, postal, city, province, vicinity, contact_name, contact_phone, contact_cell, contact_email, pm_name, pm_phone, pm_cell, pm_email, address_notes, billing_name, company_id, unit_suite) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $code, PDO::PARAM_STR);
		$stmt->bindParam(2, $address, PDO::PARAM_STR);
		$stmt->bindParam(3, $postal, PDO::PARAM_STR);
		$stmt->bindParam(4, $city, PDO::PARAM_STR);
		$stmt->bindParam(5, $province, PDO::PARAM_STR);
		$stmt->bindParam(6, $vicinity, PDO::PARAM_STR);
		$stmt->bindParam(7, $name, PDO::PARAM_STR);
		$stmt->bindParam(8, $phone, PDO::PARAM_STR);
		$stmt->bindParam(9, $cell, PDO::PARAM_STR);
		$stmt->bindParam(10, $email, PDO::PARAM_STR);
		$stmt->bindParam(11, $pm, PDO::PARAM_STR);
		$stmt->bindParam(12, $pm_phone, PDO::PARAM_STR);
		$stmt->bindParam(13, $pm_cell, PDO::PARAM_STR);
		$stmt->bindParam(14, $pm_email, PDO::PARAM_STR);
		$stmt->bindParam(15, $notes, PDO::PARAM_STR);
		$stmt->bindParam(16, $billing_name, PDO::PARAM_STR);
		$stmt->bindParam(17, $company, PDO::PARAM_INT);
		$stmt->bindParam(18, $suite, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

                       //     $address1, $postal, $city, $province, $address2, $phone1, $cell, $phone2, $id, $companySuite))
function insertCustomerAddress($address, $postal, $city, $province, $name, $phone, $cell, $email, $company, $suite, $country) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO Customer(address, postal, city, province, contact_name, contact_phone, contact_cell, contact_email, company_id, unit_suite, country) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $address, PDO::PARAM_STR);
		$stmt->bindParam(2, $postal, PDO::PARAM_STR);
		$stmt->bindParam(3, $city, PDO::PARAM_STR);
		$stmt->bindParam(4, $province, PDO::PARAM_STR);
		$stmt->bindParam(5, $name, PDO::PARAM_STR);
		$stmt->bindParam(6, $phone, PDO::PARAM_STR);
		$stmt->bindParam(7, $cell, PDO::PARAM_STR);
		$stmt->bindParam(8, $email, PDO::PARAM_STR);
		$stmt->bindParam(9, $company, PDO::PARAM_INT);
		$stmt->bindParam(10, $suite, PDO::PARAM_STR);
		$stmt->bindParam(11, $country, PDO::PARAM_STR);
		
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function updateAddress($code, $address, $postal, $city, $province, $vicinity, $name, $phone, $cell, $email, $pm, $pm_phone, $pm_cell, $pm_email, $notes, $billing_name, $company, $suite, $country, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Customer SET ccode = ?, address = ?, postal = ?, city = ?, province = ?, vicinity = ?, contact_name = ?, contact_phone = ?, contact_cell = ?, contact_email = ?, pm_name = ?, pm_phone = ?, pm_cell = ?, pm_email = ?, address_notes = ?, billing_name = ?, company_id = ?, unit_suite = ?, country = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $code, PDO::PARAM_STR);
		$stmt->bindParam(2, $address, PDO::PARAM_STR);
		$stmt->bindParam(3, $postal, PDO::PARAM_STR);
		$stmt->bindParam(4, $city, PDO::PARAM_STR);
		$stmt->bindParam(5, $province, PDO::PARAM_STR);
		$stmt->bindParam(6, $vicinity, PDO::PARAM_STR);
		$stmt->bindParam(7, $name, PDO::PARAM_STR);
		$stmt->bindParam(8, $phone, PDO::PARAM_STR);
		$stmt->bindParam(9, $cell, PDO::PARAM_STR);
		$stmt->bindParam(10, $email, PDO::PARAM_STR);
		$stmt->bindParam(11, $pm, PDO::PARAM_STR);
		$stmt->bindParam(12, $pm_phone, PDO::PARAM_STR);
		$stmt->bindParam(13, $pm_cell, PDO::PARAM_STR);
		$stmt->bindParam(14, $pm_email, PDO::PARAM_STR);
		$stmt->bindParam(15, $notes, PDO::PARAM_STR);
		$stmt->bindParam(16, $billing_name, PDO::PARAM_STR);
		$stmt->bindParam(17, $company, PDO::PARAM_INT);
		$stmt->bindParam(18, $suite, PDO::PARAM_STR);
		$stmt->bindParam(19, $country, PDO::PARAM_STR);
		$stmt->bindParam(20, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function deleteAddress($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Customer SET active = 0 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function deleteAddressCompletely($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "DELETE FROM Customer WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
	/*
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Customer SET active = 0 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
	*/
}




function getCompany($id) {
	$sql = "SELECT * FROM Company WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function getCompanies() {
	$sql = "SELECT * FROM Company WHERE active = 1 ORDER BY company_name";
	return simpleSelect($sql);
}
function getCompaniesWithAddresses() {
    $sql = "
      SELECT DISTINCT c.*
      FROM Company AS c
      JOIN Customer AS cu
        ON cu.company_id = c.id
      WHERE c.active = 1 AND c.onhold = 0
      ORDER BY c.company_name
    ";
    return simpleSelect($sql);
}

/*
function getCompaniesWithAddresses() {
    $sql = "
      SELECT c.*
      FROM Company AS c
      WHERE c.active = 1
        AND EXISTS (
          SELECT 1
          FROM Customer AS cu
          WHERE cu.company_id = c.company_id
        )
      ORDER BY c.company_name
    ";
    return simpleSelect($sql);
}
*/

function exportCompanyBook() {
	try {
		$sql = '
			SELECT
				id,
				company_name,
				address1,
				address2,
				city,
				province,
				postal,
				phone1,
				phone2,
				fax,
				cell,
				p_rate,
				e_rate,
				h_rate,
				terms,
				if(onhold, "YES", "NO") AS onhold,
				if(active, "YES", "NO") AS active
			FROM Company
		';
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        //Step 2 - establish database connection
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        //Step 3 - execute an SQL statement
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        //Step 4 - process the query results
        return $stmt;
    } catch (Exception $ex) {
        echo "DB Exception: " . $ex->getMessage();
        return null;
    } finally {
        //Step 5 - close your database connection
        $pdo = null;
    }
}

function getActiveCompanies() {
	$sql = "SELECT * FROM Company WHERE active = 1 AND onhold = 0 ORDER BY company_name";
	return simpleSelect($sql);
}

function insertCompany($name, $address1, $address2, $city, $province, $postal, $phone1, $phone2, $fax, $cell, $p_rate, $e_rate, $h_rate, $terms, $onhold, $companySuite,$country) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO Company(company_name, address1, address2, city, province, postal, phone1, phone2, fax, cell, p_rate, e_rate, h_rate, terms, onhold, companySuite, country) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $name, PDO::PARAM_STR);
		$stmt->bindParam(2, $address1, PDO::PARAM_STR);
		$stmt->bindParam(3, $address2, PDO::PARAM_STR);
		$stmt->bindParam(4, $city, PDO::PARAM_STR);
		$stmt->bindParam(5, $province, PDO::PARAM_STR);
		$stmt->bindParam(6, $postal, PDO::PARAM_STR);
		$stmt->bindParam(7, $phone1, PDO::PARAM_STR);
		$stmt->bindParam(8, $phone2, PDO::PARAM_STR);
		$stmt->bindParam(9, $fax, PDO::PARAM_STR);
		$stmt->bindParam(10, $cell, PDO::PARAM_STR);
		$stmt->bindParam(11, $p_rate, PDO::PARAM_STR);
		$stmt->bindParam(12, $e_rate, PDO::PARAM_STR);
		$stmt->bindParam(13, $h_rate, PDO::PARAM_STR);
		$stmt->bindParam(14, $terms, PDO::PARAM_STR);
		$stmt->bindParam(15, $onhold, PDO::PARAM_STR);
        $stmt->bindParam(16, $companySuite, PDO::PARAM_STR);
        $stmt->bindParam(17, $country, PDO::PARAM_STR);
		

		$stmt->execute();
		$count = $stmt->rowCount();
		if ($stmt->rowCount() > 0) {
        return $pdo->lastInsertId(); // ✅ return only
    } else {
        return false;
    }
		/*
		 if ($stmt->rowCount() > 0) {
        return $pdo->lastInsertId();
    } else {
        return false;
    }
		*/
		/*
		if ($count > 0) {
			$id = $pdo->lastInsertId();
			return $id;
		}
		*/
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}



function updateCompany($id, $name, $address1, $address2, $city, $province, $postal, $phone1, $phone2, $fax, $cell, $p_rate, $e_rate, $h_rate, $terms, $hold, $companySuite, $country) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Company SET company_name = ?, address1 = ?, address2 = ?, city = ?, province = ?, postal = ?, phone1 = ?, phone2 = ?, fax = ?, cell = ?, p_rate = ?, e_rate = ?, h_rate = ?, terms = ?, onhold = ?, companySuite = ?, country = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $name, PDO::PARAM_STR);
		$stmt->bindParam(2, $address1, PDO::PARAM_STR);
		$stmt->bindParam(3, $address2, PDO::PARAM_STR);
		$stmt->bindParam(4, $city, PDO::PARAM_STR);
		$stmt->bindParam(5, $province, PDO::PARAM_STR);
		$stmt->bindParam(6, $postal, PDO::PARAM_STR);
		$stmt->bindParam(7, $phone1, PDO::PARAM_STR);
		$stmt->bindParam(8, $phone2, PDO::PARAM_STR);
		$stmt->bindParam(9, $fax, PDO::PARAM_STR);
		$stmt->bindParam(10, $cell, PDO::PARAM_STR);
		$stmt->bindParam(11, $p_rate, PDO::PARAM_STR);
		$stmt->bindParam(12, $e_rate, PDO::PARAM_STR);
		$stmt->bindParam(13, $h_rate, PDO::PARAM_STR);
		$stmt->bindParam(14, $terms, PDO::PARAM_STR);
		$stmt->bindParam(15, $hold, PDO::PARAM_INT);
        $stmt->bindParam(16, $companySuite, PDO::PARAM_STR);
        $stmt->bindParam(17, $country, PDO::PARAM_STR);
		$stmt->bindParam(18, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function deleteCompany($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Company SET active = 0 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function getUserDetail($id) {
	$sql = "SELECT * FROM Users WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function getUsers($showinactive = false) {
	if ($showinactive) {
		$sql = "SELECT * FROM Users";
	} else {
		$sql = "SELECT * FROM Users WHERE active = 1";
	}
	return simpleSelect($sql);
}

function updateUser($id, $username, $name, $phone, $type, $employee_type) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Users SET username = ?, name = ?, phone = ?, type = ?, employee_type = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $username, PDO::PARAM_STR);
		$stmt->bindParam(2, $name, PDO::PARAM_STR);
		$stmt->bindParam(3, $phone, PDO::PARAM_STR);
		$stmt->bindParam(4, $type, PDO::PARAM_STR);
		$stmt->bindParam(5, $employee_type, PDO::PARAM_STR);
		$stmt->bindParam(6, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function insertUser($username, $password, $name, $phone, $type, $employee_type) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "INSERT INTO Users(username, password, name, phone, type, employee_type) VALUES(?,?,?,?,?,?)";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $username, PDO::PARAM_STR);
		$stmt->bindParam(2, $password, PDO::PARAM_STR);
		$stmt->bindParam(3, $name, PDO::PARAM_STR);
		$stmt->bindParam(4, $phone, PDO::PARAM_STR);
		$stmt->bindParam(5, $type, PDO::PARAM_STR);
		$stmt->bindParam(6, $employee_type, PDO::PARAM_STR);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function deleteUser($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Users SET active = 0 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function activateUser($id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Users SET active = 1 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function updatePassword($id, $password) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE Users SET password = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $password, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function getPassword($username) {
	$sql = "SELECT id, password FROM Users WHERE username = ?";
	$params = array($username);
	return preparedSelect($sql, $params);
}

function rescheduleOngoing($id, $date) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET next_service_date = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $date, PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function flagWorkOrder($id, $flag) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET flag = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $flag, PDO::PARAM_INT);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function isDuplicatePO($po, $companyId, $id) {
    // Return true immediately if companyId is empty or null
    if ($companyId === "" || $companyId === null) {
        return true;
    }

    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $sql = "
            SELECT po 
            FROM WorkOrder 
            WHERE po = :po 
              AND companyId = :companyId 
              AND id != :id 
            LIMIT 1
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':po', $po);
        $stmt->bindParam(':companyId', $companyId);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result !== false;

    } catch (PDOException $e) {
        echo "Database error: " . $e->getMessage();
    } finally {
        $pdo = null;
    }
}



/* companyId 1
function isDuplicatePO($po, $companyId, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "SELECT po FROM WorkOrder WHERE po = :po AND companyId LIKE :companyId AND id NOT LIKE :id LIMIT 0,1";
		//$sql = "SELECT po FROM WorkOrder WHERE po = :po AND customer_id LIKE :customer_id LIMIT 0,1";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(':po', $po);
		$stmt->bindParam(':companyId', $companyId);
		$stmt->bindParam(':id', $id);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
*/

/*  
function isDuplicatePO($po, $customer_id, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "SELECT po FROM WorkOrder WHERE po = :po  LIMIT 0,1";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(':po', $po);
		$stmt->bindParam(':customer_id', $customer_id);
		$stmt->bindParam(':id', $id);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
*/
/* only true no companyId
function isDuplicatePO($po, $company_id, $id = null) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Build base SQL with JOIN
        $sql = "
            SELECT WorkOrder.po 
            FROM WorkOrder
            INNER JOIN Customer ON WorkOrder.customer_id = Customer.id
            WHERE WorkOrder.po = :po
              AND Customer.company_id = :company_id
        ";

        // Exclude current WorkOrder ID if provided
        if (!empty($id)) {
            $sql .= " AND WorkOrder.id != :id";
        }

        $sql .= " LIMIT 1";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':po', $po);
        $stmt->bindParam(':company_id', $company_id);
        if (!empty($id)) {
            $stmt->bindParam(':id', $id);
        }
		$stmt->execute();
		$count = $stmt->rowCount();

        $stmt->execute();
        return $stmt->rowCount() > 0;

    } catch (PDOException $e) {
        echo "Database error: " . $e->getMessage();
    } finally {
        $pdo = null;
    }
}
*/
/* working customer query
function isDuplicatePO($po, $customer_id, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "SELECT po FROM WorkOrder WHERE po = :po AND customer_id LIKE :customer_id AND id NOT LIKE :id LIMIT 0,1";
		//$sql = "SELECT po FROM WorkOrder WHERE po = :po AND customer_id LIKE :customer_id LIMIT 0,1";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(':po', $po);
		$stmt->bindParam(':customer_id', $customer_id);
		$stmt->bindParam(':id', $id);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
*/
/* ORIG
function isDuplicatePO($po, $customer_id, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "SELECT po FROM WorkOrder WHERE po = :po AND customer_id LIKE :customer_id AND id NOT LIKE :id LIMIT 0,1";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(':po', $po);
		$stmt->bindParam(':customer_id', $customer_id);
		$stmt->bindParam(':id', $id);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
*/
function isDuplicateProjNum($projNum, $id) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

       // $sql = "SELECT productionCode FROM WorkOrder WHERE productionCode = :productionCode AND id != :id LIMIT 1";
		 $sql = "SELECT productionCode FROM WorkOrder WHERE productionCode = :productionCode LIMIT 1";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':productionCode', $projNum);
        //$stmt->bindParam(':id', $id);
        $stmt->execute();

        return $stmt->rowCount() > 0;
    } catch (PDOException $e) {
        echo $e->getMessage();
      //  return false;
    } finally {
        $pdo = null;
    }
}

/*
function isDuplicateProjNum($projNum, $id) {
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	// $sql = "SELECT po FROM WorkOrder WHERE po = :po AND customer_id LIKE :customer_id AND id NOT LIKE :id LIMIT 0,1";	
		$sql = "SELECT po FROM WorkOrder WHERE productionCode = :projNum LIMIT 0,1";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(':productionCode', $projNum);
		$stmt->bindParam(':id', $id);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch (PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}
*/ 

function checkIfTechnicianLoggedTime($id){
	$sql = "SELECT *  FROM TimeCards WHERE work_order_id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}

function appendSignatureDates($ar,$id){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET signatures = ? WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1,$ar,PDO::PARAM_STR);
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


function getSignatureDates($id){
$sql = "SELECT * FROM WorkOrder WHERE id = ?";
$params = array($id);
 return preparedSelect($sql, $params);
}

function getCompletedDate($id){
	$sql = "SELECT * FROM WorkOrder WHERE id = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}


function getMonthsWorkOrder($thisMonth, $nextMonth) {

	//$sql = "SELECT c.*, wo.* FROM WorkOrder as wo LEFT JOIN Customer AS c ON c.id = wo.customer_id WHERE wo.id = ?";
	//$params = array($id);
//array_push($params,$id);
	//$params = array_fill($id);
	$sql = "SELECT c.*, wo.* 
	        FROM WorkOrder 
			as wo	
            LEFT JOIN Customer AS c			
			ON c.id = wo.customer_id
			WHERE wo.id = ?";

	$params = array($id);
	//echo 'ok -> '.$params[0];
	//print_r($sql);

	$params = array($id);
	return preparedSelect($sql, $params);
}

/*
function getGroups($id) {
	$sql = "SELECT * FROM `GroupedJobs` WHERE `wo_id` = 37838";
	$params = array($id);
	return preparedSelect($sql, $params);
}
*/
/* basic working for 1 id
function getGroups($id) {
	//$sql = "SELECT * FROM Company WHERE id = ?";
	$sql = "SELECT * FROM `GroupedJobs` WHERE `group_id` = ?";
	$params = array($id);
	return preparedSelect($sql, $params);
}
*/
/*
function getCurrentGrp($id) {
    $sql = "
        SELECT wo.*, g.*
        FROM WorkOrder AS wo
        INNER JOIN GroupedJobs AS g ON g.group_id = wo.groupId
        WHERE g.group_id = ?
          AND wo.group_active = 1
    ";
    $params = array($id);
    return preparedSelect($sql, $params);
}
*/
/*
function getCurrentGrp($id) {
    $sql = "
        SELECT wo.wo_number, wo.productionCode, wo.work_required, wo.type
        FROM WorkOrder AS wo
        INNER JOIN GroupedJobs AS g ON g.group_id = wo.groupId
        WHERE g.group_id = ?
		 AND g.active_g = 1
          AND wo.group_active = 1
    ";
    $params = array($id);
    return preparedSelect($sql, $params);
}
*/
/* good no customer,company
function getCurrentGrp($id) {
    $sql = "
        SELECT 
            wo.wo_number, 
            wo.productionCode, 
            wo.work_required, 
            wo.type,
			g.group_color,
            g.group_title
        FROM WorkOrder AS wo
        INNER JOIN GroupedJobs AS g ON g.group_id = wo.groupId
        WHERE g.group_id = ?
          AND g.active_g = 1
          AND wo.group_active = 1
    ";
    $params = array($id);
    return preparedSelect($sql, $params);
}
	*/

	/*HERE     Omitted from function...always show defunct groups       
	AND g.active_g = 1
    AND wo.group_active = 1
*/
	function getCurrentGrp($id) {
    $sql = "
        SELECT 
		    wo.id,
            wo.wo_number, 
            wo.productionCode, 
            wo.work_required, 
            wo.type,
			wo.status,
            g.group_color,
            g.group_title,
			 g.group_description,
            c.address AS customer_address,
			c.unit_suite,
            co.company_name
        FROM WorkOrder AS wo
        INNER JOIN GroupedJobs AS g ON g.group_id = wo.groupId
        INNER JOIN Customer AS c ON wo.customer_id = c.id
        INNER JOIN Company AS co ON c.company_id = co.id
        WHERE g.group_id = ?

    ";
    $params = array($id);
    return preparedSelect($sql, $params);
}




function updateGroupMember($id) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Step 1: Update the WorkOrder if it has a valid groupId
        $sql = "UPDATE WorkOrder 
                   SET group_item_complete = 1 
                 WHERE id = ? 
                   AND groupId IS NOT NULL 
                   AND groupId != 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_INT);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            // Step 2: Get the groupId for this work order
            $sqlGroup = "SELECT groupId FROM WorkOrder WHERE id = ?";
            $stmtGroup = $pdo->prepare($sqlGroup);
            $stmtGroup->bindParam(1, $id, PDO::PARAM_INT);
            $stmtGroup->execute();
            $groupId = $stmtGroup->fetchColumn();

            if ($groupId) {
                // Step 3: Check if any other work orders in this group are incomplete
                $sqlCheck = "SELECT COUNT(*) 
                               FROM WorkOrder 
                              WHERE groupId = ? 
                                AND group_item_complete != 1";
                $stmtCheck = $pdo->prepare($sqlCheck);
                $stmtCheck->bindParam(1, $groupId, PDO::PARAM_INT);
                $stmtCheck->execute();
                $remaining = $stmtCheck->fetchColumn();

                // Step 4: If none remain, mark the group inactive
                if ($remaining == 0) {
                    $sqlUpdateGroup = "UPDATE GroupedJobs 
                                          SET active_g = 0 
                                        WHERE group_id = ?";
                    $stmtUpdateGroup = $pdo->prepare($sqlUpdateGroup);
                    $stmtUpdateGroup->bindParam(1, $groupId, PDO::PARAM_INT);
                    $stmtUpdateGroup->execute();
                }
            }

            return true;
        }
    } catch(PDOException $e) {
        echo $e->getMessage();
    } finally {
        $pdo = null;
    }
}

/*basic
function updateGroupMember($id) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Only update if groupId is not null and not 0
        $sql = "UPDATE WorkOrder 
                   SET group_item_complete = 1 
                 WHERE id = ? 
                   AND groupId IS NOT NULL 
                   AND groupId != 0";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_INT);
        $stmt->execute();

        $count = $stmt->rowCount();
        if ($count > 0) {
            return true;
        }
    } catch(PDOException $e) {
        echo $e->getMessage();
    } finally {
        $pdo = null;
    }   
}
*/




/*
function getTheGrp($id) {
    // Step 1: Get the groupId and type for the given WorkOrder ID
    $groupCheckSql = "SELECT groupId, type FROM WorkOrder WHERE id = ? AND groupId >= 1 AND group_active = 1";
    $groupResult = preparedSelect($groupCheckSql, array($id));

    if (empty($groupResult) || empty($groupResult[0]['groupId'])) {
        return array(); // No valid group found
    }

    $groupId = $groupResult[0]['groupId'];
    $type = $groupResult[0]['type'];

    // Step 2: Choose which field to select based on type
    $field = in_array($type, ['Service', 'Hardware']) ? 'wo_number' : 'productionCode';

    // Step 3: Get all values for that field in the group
    $sql = "SELECT {$field} FROM WorkOrder WHERE groupId = ? AND group_active = 1";
    $params = array($groupId);
    $results = preparedSelect($sql, $params);

    // Step 4: Extract values into a flat array
    $values = array_map(function($row) use ($field) {
        return $row[$field];
    }, $results);

    return $values;
}
*/
function getTheGrp($id) {
    // Step 1: Get the groupId and type for the given WorkOrder ID
    $checkSql = "SELECT groupId, type FROM WorkOrder WHERE id = ? AND groupId >= 1 AND group_active = 1";
    $checkResult = preparedSelect($checkSql, array($id));

    if (empty($checkResult) || empty($checkResult[0]['groupId'])) {
        return array(); // No valid group or inactive
    }

    $type = $checkResult[0]['type'];
    $groupId = $checkResult[0]['groupId'];

    // Step 2: Only proceed if type is Closets or Doors
    if (!in_array($type, ['Closets', 'Doors'])) {
        return array(); // Ignore other types
    }

    // Step 3: Get all productionCode values for that group with matching type
    $sql = "SELECT productionCode FROM WorkOrder WHERE groupId = ? AND group_active = 1 AND type IN ('Closets', 'Doors')";
    $results = preparedSelect($sql, array($groupId));

    // Step 4: Extract productionCode values into a flat array
    $codes = array_map(function($row) {
        return $row['productionCode'];
    }, $results);

    return $codes;
}



//NOTE  ORDER BY group_id DESC, created_at DESC
function getActiveGroups() {
    $sql = "
        SELECT *
        FROM GroupedJobs
        WHERE active_g = 1  ORDER BY group_id DESC
    ";
    return preparedSelect($sql, []);
}

function createGroupNew($id, $groupTitle, $groupDescription, $chosenColor) {
  // Database connection
  $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
  $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // Insert into GroupedJobs
  $sql = "INSERT INTO GroupedJobs (group_title, group_description, group_color, active_g)
          VALUES (:title, :description, :color, 1)";
  $stmt = $pdo->prepare($sql);
  $stmt->execute([
    ':title' => $groupTitle,
    ':description' => $groupDescription,
    ':color' => $chosenColor
  ]);

  // Get last inserted group ID
  $groupId = $pdo->lastInsertId();

  // Update WorkOrder with new group ID
  $updateSql = "UPDATE WorkOrder
                SET groupId = :groupId,
                    group_active = 1
                WHERE id = :id";
  $updateStmt = $pdo->prepare($updateSql);
  $updateStmt->execute([
    ':groupId' => $groupId,
    ':id' => $id
  ]);
}

function addToGroup($gid,$id){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE WorkOrder SET groupId = ?, group_active = 1 WHERE id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $gid, PDO::PARAM_INT);
		
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}

function changeGroupColor($color,$id){
	try {
		$ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
		$pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "UPDATE GroupedJobs SET group_color = ? WHERE group_id = ?";
		$stmt = $pdo->prepare($sql);
		$stmt->bindParam(1, $color, PDO::PARAM_STR);
		
		$stmt->bindParam(2, $id, PDO::PARAM_INT);
		$stmt->execute();
		$count = $stmt->rowCount();
		if ($count > 0) {
			return true;
		}
	} catch(PDOException $e) {
		echo $e->getMessage();
	} finally {
		$pdo = null;
	}
}


function deleteAllGroup(array $ids, $group_id) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Begin transaction to ensure both operations succeed together
        $pdo->beginTransaction();

        // 1. Update WorkOrder table
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $sqlUpdate = "UPDATE WorkOrder SET groupId = 0, group_active = 0 WHERE id IN ($placeholders)";
        $stmtUpdate = $pdo->prepare($sqlUpdate);
        $stmtUpdate->execute($ids);

        // 2. Delete from GroupedJobs table
        $sqlDelete = "DELETE FROM GroupedJobs WHERE group_id = ?";
        $stmtDelete = $pdo->prepare($sqlDelete);
        $stmtDelete->execute([$group_id]);

        // Commit transaction
        $pdo->commit();

        return $stmtUpdate->rowCount() > 0 || $stmtDelete->rowCount() > 0;
    } catch(PDOException $e) {
        if ($pdo && $pdo->inTransaction()) {
            $pdo->rollBack();
        }
        error_log($e->getMessage());
        return false;
    } finally {
        $pdo = null;
    }
}


function deleteFromGroup(array $ids) {
    try {
        $ds = "mysql:host=" . DBSERVER . ";dbname=" . DBNAME;
        $pdo = new PDO($ds, DBUSERNAME, DBPASSWORD);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Build placeholders for IN clause
        $placeholders = implode(',', array_fill(0, count($ids), '?'));

        $sql = "UPDATE WorkOrder SET groupId = 0, group_active = 0 WHERE id IN ($placeholders)";
        $stmt = $pdo->prepare($sql);

        // Execute with array of IDs
        $stmt->execute($ids);

        $count = $stmt->rowCount();
        return $count > 0;
    } catch(PDOException $e) {
        error_log($e->getMessage()); // safer than echoing
        return false;
    } finally {
        $pdo = null;
    }
}



/* need to add?
function getActiveGroups() {
      $sql = "
        SELECT wo.*, g.*
        FROM WorkOrder AS wo
        INNER JOIN GroupedJobs AS g ON g.group_id = wo.groupId
        WHERE wo.group_active = 1
    ";
    $params = array($id);
    return preparedSelect($sql, $params);
}
*/

?>